% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{jags2_baker}
\alias{jags2_baker}
\title{Run \code{JAGS} from R}
\usage{
jags2_baker(
  data,
  inits,
  parameters.to.save,
  model.file = "model.bug",
  n.chains = 3,
  n.iter = 2000,
  n.burnin = floor(n.iter/2),
  n.thin = max(1, floor((n.iter - n.burnin)/1000)),
  DIC = TRUE,
  jags.path = "",
  working.directory = NULL,
  clearWD = TRUE,
  refresh = n.iter/50
)
}
\arguments{
\item{data}{(1) a vector or list of the names of the data objects used by
    the model, (2) a (named) list of the data objects themselves, or
  (3) the name of a "dump" format file containing the data objects,
   which must end in ".txt", see example below for details.}

\item{inits}{a list with \code{n.chains} elements; each element of the
    list is itself a list of starting values for the \code{BUGS} model,
    \emph{or} a function creating (possibly random) initial values. If inits is
    \code{NULL}, \code{JAGS} will generate initial values for parameters.}

\item{parameters.to.save}{character vector of the names of the
    parameters to save which should be monitored.}

\item{model.file}{file containing the model written in \code{BUGS}
  code. Alternatively, as in \pkg{R2WinBUGS}, \code{model.file} can be an R
  function that contains a \code{BUGS} model that is written to a
  temporary model file (see \code{tempfile}) using \code{write.model}}

\item{n.chains}{number of Markov chains (default: 3)}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.burnin}{length of burn in, i.e. number of iterations to
    discard at the beginning. Default is \code{n.iter/2}, that is,
    discarding the first half of the simulations. If n.burnin is 0,
    \code{jags()} will run 100 iterations for adaption.}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}

\item{DIC}{logical; if \code{TRUE} (default), compute deviance, pD,
    and DIC. The rule \code{pD=var(deviance) / 2} is used.}

\item{jags.path}{directory that contains the \code{JAGS} executable.
    The default is \dQuote{}.  }

\item{working.directory}{sets working directory during execution of
    this function; This should be the directory where model file is.}

\item{clearWD}{indicating whether the files \file{data.txt},
    \file{inits[1:n.chains].txt}, \file{codaIndex.txt}, \file{jagsscript.txt},
    and \file{CODAchain[1:nchains].txt} should be removed after \code{jags} has
    finished, default=TRUE.}

\item{refresh}{refresh frequency for progress bar, default is \code{n.iter/50}}
}
\value{
Same as \code{\link[R2jags:jags]{R2jags::jags()}}
}
\description{
The jags function takes data and starting values as input.
It automatically writes a jags script, calls the model, and saves the
simulations for easy access in R. Check the R2jags::jags2 for details about
the argument.
}
\details{
This modifies the jags2 function in R2jags package.
}
\seealso{
\code{\link[R2jags:jags]{R2jags::jags()}}
}
