% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop.R
\name{super}
\alias{super}
\title{Get the parent class (the next class based on the method resolution order)}
\usage{
super(self_name = "self", mro_current_name = "..mro_current..", where = NULL)
}
\arguments{
\item{self_name}{Character. The name of the self reference.}

\item{mro_current_name}{Character. The name of the variable storing
the current class. This is used to determine the next class.}

\item{where}{Environment/Character. The target environment to search for the
parent class. If \code{where == NULL}, the parent environment of self will be used.
If a character value is provided, the package with the same name will be used.}
}
\value{
A \code{bandicoot} object which is an environment.
}
\description{
This function gets the parent class or the next class based on the method
resolution order. This is useful when one wants to access the overwritten
parent class method or the overwritten parent class attribute.
}
\details{
Note that this function assumes the parent class can be found in the
parent environment of the current object. If one wants to find the
parent class from a package, it needs to be specified via the \code{where}
argument.
}
\examples{

# Define class O
O <- new_class(class_name = "O")
register_method(O, foo = function() {
  print("Calling class O `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
})

# Define class F
F <- new_class(O, class_name = "F")
register_method(F, foo = function() {
  print("Calling class F `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# Define class E
E <- new_class(O, class_name = "E")
register_method(E, foo = function() {
  print("Calling class E `foo` method")
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# Define class D
D <- new_class(O, class_name = "D")
register_method(D, foo = function() {
  print("Calling class D `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# Define class C
C <- new_class(D, F, class_name = "C")
register_method(C, foo = function() {
  print("Calling class C `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# Define class B
B <- new_class(E, D, class_name = "B")
register_method(B, foo = function() {
  print("Calling class B `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# Define class A
A <- new_class(B, C, class_name = "A")
register_method(A, foo = function() {
  print("Calling class A `foo` method")
  print(paste0("Self is ", self$my_name))
  print(paste0("Next class is ", super()$..type..))
  use_method(self, super()$foo)()
})

# To understand why the order is A, B, E, C, D, F, O,
# please check [https://www.python.org/download/releases/2.3/mro/].
a <- A$instantiate()
a$my_name <- "a"
a$foo()


}
