% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{ridge_muhat_lfo_pai}
\alias{ridge_muhat_lfo_pai}
\title{Leave-future-out ridge-based estimates for arm expected rewards.}
\usage{
ridge_muhat_lfo_pai(xs, ws, yobs, K, batch_sizes, alpha = 1)
}
\arguments{
\item{xs}{Matrix. Covariates of shape \code{[A, p]}, where \code{A} is the number of observations and \code{p} is the number of features. Must not contain NA values.}

\item{ws}{Integer vector. Indicates which arm was chosen for observations at each time \code{t}. Length \code{A}. Must not contain NA values.}

\item{yobs}{Numeric vector. Observed outcomes, length \code{A}. Must not contain NA values.}

\item{K}{Integer. Number of arms. Must be a positive integer.}

\item{batch_sizes}{Integer vector. Sizes of batches in which data is processed. Must be positive integers.}

\item{alpha}{Numeric. Ridge regression regularization parameter. Default is 1.}
}
\value{
A 3D array containing the expected reward estimates for each arm and each time \code{t}, of shape \code{[A, A, K]}.
}
\description{
Computes leave-future-out ridge-basedn estimates of arm expected rewards based on provided data.
}
\examples{
set.seed(123)
p <- 3
K <- 5
A <- 100
xs <- matrix(runif(A * p), nrow = A, ncol = p)
ws <- sample(1:K, A, replace = TRUE)
yobs <- runif(A)
batch_sizes <- c(25, 25, 25, 25)
muhat <- ridge_muhat_lfo_pai(xs, ws, yobs, K, batch_sizes)
print(muhat)

}
