% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_maptypes.R
\name{get_maptypes}
\alias{get_maptypes}
\title{Get all supported map types}
\source{
\code{"osm"}: Open Street Map contributors (\url{https://www.openstreetmap.org/copyright}), Open Topo Map (\url{https://opentopomap.org/})

\code{"osm_stamen"}: Stamen (\url{https://maps.stamen.com/}) via Stadia Maps (\url{https://stadiamaps.com/}), Open Street Map contributors (\url{https://www.openstreetmap.org/copyright})

\code{"osm_stadia"}: Stadia Maps (\url{https://stadiamaps.com/}), Open Street Map contributors (\url{https://www.openstreetmap.org/copyright})

\code{"osm_thunderforest"}: Thunderforest (\url{https://www.thunderforest.com/}), Open Street Map contributors (\url{https://www.openstreetmap.org/copyright})

\code{"carto"}: Carto (\url{https://carto.com/})

\code{"mapbox"}: Mapbox (\url{https://www.mapbox.com})

\code{"esri"}: Esri (\url{https://www.esri.com/en-us/home})
}
\usage{
get_maptypes(map_service = NULL)
}
\arguments{
\item{map_service}{character, optional, either \code{"osm"}, \code{"osm_stamen"}, \code{"osm_stadia"}, \code{"osm_thunderforest"},  \code{"carto"}, \code{"mapbox"} or \code{"esri"}. Otherwise, a list of map types for both services is returned.}
}
\value{
A character vector of supported map types
}
\description{
This function returns every supported map type that can be used as input to the \code{map_type} argument of \code{\link{set_defaults}}, \code{\link{basemap}} or associated functions.
}
\examples{
# for all services
get_maptypes()

# for osm only
get_maptypes("osm")
# or
get_maptypes()$osm

# for mapbox only
get_maptypes("mapbox")
# or
get_maptypes()$mapbox

# same for all other map services

}
\seealso{
\code{\link{basemap}}
}
