% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.R
\name{ridge}
\alias{ridge}
\alias{fitted.ridge}
\alias{coef.ridge}
\alias{predict.ridge}
\title{Ridge regression}
\usage{
ridge(formula, data, penalty = "auto", ...)

\method{fitted}{ridge}(object, ...)

\method{coef}{ridge}(object, ...)

\method{predict}{ridge}(object, newdata, ...)
}
\arguments{
\item{formula}{A model formula; see \link{formula}. The intercept term is
unpenalized; to fit a penalized intercept, remove the intercept and add
your own to the design matrix.}

\item{data}{An optional data frame or object in which to interpret the
variables occurring in formula.}

\item{penalty}{The ridge penalty. Must be a single numeric or the string
"auto", in which case the penalty will be determined via leave-one-out
cross validation to minimize the mean squared error.}

\item{...}{Further arguments, passed on to \code{\link[=model.frame]{model.frame()}} and
\code{\link[=model.matrix]{model.matrix()}}. These must be provided to \code{\link[=predict.ridge]{predict.ridge()}} as well,
if used.}

\item{object}{A fitted \code{\link[=ridge]{ridge()}} model.}

\item{newdata}{A data frame containing the new data to predict}
}
\value{
An object of class \code{ridge} with components including:
\itemize{
\item \code{coef}, a vector of coefficients.
\item \code{fitted}, a vector of fitted values.
\item \code{penalty}, the penalty value.
}
}
\description{
Lightweight routine for ridge regression, fitted via a singular value
decomposition. The penalty may be automatically determined by leave-one-out
cross validation. The intercept term is unpenalized.
}
\section{Methods (by generic)}{
\itemize{
\item \code{fitted(ridge)}: Fitted values

\item \code{coef(ridge)}: Coefficients

\item \code{predict(ridge)}: Predicted values

}}
\examples{
m_lm = lm(mpg ~ ., mtcars)
m_ridge = ridge(mpg ~ ., mtcars, penalty=1e3)
plot(fitted(m_lm), fitted(m_ridge), ylim=c(10, 30))
abline(a=0, b=1, col="red")

}
