% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableOpenXlsxStyle.R
\docType{class}
\name{TableOpenXlsxStyle}
\alias{TableOpenXlsxStyle}
\title{R6 class that specifies Excel styling as used by the openxlsx package.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `TableOpenXlsxStyle` class specifies the styling for cells in an
Excel worksheet.
}
\examples{
# This class should only be created by using the functions in the table.
# It is not intended to be created by users outside of the table.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
library(openxlsx)
wb <- createWorkbook(creator = Sys.getenv("USERNAME"))
addWorksheet(wb, "Data")
tbl$writeToExcelWorksheet(wb=wb, wsName="Data",
                         topRowNumber=1, leftMostColumnNumber=1,
                         applyStyles=TRUE, mapStylesFromCSS=TRUE)
# Use saveWorkbook() to save the Excel file.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{baseStyleName}}{The name of the base style in the table.}

\item{\code{isBaseStyle}}{`TRUE` when this style is the equivalent of a named style in
the table, `FALSE` if this style has additional settings over and above
the base style of the same name.}

\item{\code{fontName}}{The name of the font (single font name, not a CSS style
list).}

\item{\code{fontSize}}{The size of the font (units: point).}

\item{\code{bold}}{TRUE` if text is bold.}

\item{\code{italic}}{`TRUE` if text is italic.}

\item{\code{underline}}{`TRUE` if text is underlined.}

\item{\code{strikethrough}}{`TRUE` if text has a line through it.}

\item{\code{superscript}}{`TRUE` if text is small and raised.}

\item{\code{subscript}}{`TRUE` if text is small and lowered.}

\item{\code{fillColor}}{The background colour for the cell (as a hex value, e.g.
#00FF00).}

\item{\code{textColor}}{The color of the text (as a hex value).}

\item{\code{hAlign}}{The horizontal alignment of the text:  left, center or right.}

\item{\code{vAlign}}{The vertical alignment of the text:  top, middle or bottom.}

\item{\code{wrapText}}{TRUE if the text is allowed to wrap onto multiple lines.}

\item{\code{textRotation}}{The rotation angle of the text or 255 for vertical.}

\item{\code{indent}}{The text indentation.}

\item{\code{borderAll}}{A list (with elements style and color) specifying the border
settings for all four sides of each cell at once.}

\item{\code{borderLeft}}{A list (with elements style and color) specifying the
border settings for the left border of each cell.}

\item{\code{borderRight}}{A list (with elements style and color) specifying the
border settings for the right border of each cell.}

\item{\code{borderTop}}{A list (with elements style and color) specifying the border
settings for the top border of each cell.}

\item{\code{borderBottom}}{A list (with elements style and color) specifying the
border settings for the bottom border of each cell.}

\item{\code{valueFormat}}{The Excel formatting applied to the field value.  One
of the following values: "GENERAL", "NUMBER", "CURRENCY", "ACCOUNTING",
"DATE", "LONGDATE", TIME, "PERCENTAGE", "FRACTION", "SCIENTIFIC",
"TEXT", "COMMA". Or for dates/datetimes, a combination of d, m, y. Or
for numeric values, use 0.00 etc.}

\item{\code{minColumnWidth}}{The minimum width of this column.}

\item{\code{minRowHeight}}{The minimum height of this row.}

\item{\code{openxlsxStyle}}{The return value from openxlsx::createStyle().}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TableOpenXlsxStyle-new}{\code{TableOpenXlsxStyle$new()}}
\item \href{#method-TableOpenXlsxStyle-isBasicStyleNameMatch}{\code{TableOpenXlsxStyle$isBasicStyleNameMatch()}}
\item \href{#method-TableOpenXlsxStyle-isFullStyleDetailMatch}{\code{TableOpenXlsxStyle$isFullStyleDetailMatch()}}
\item \href{#method-TableOpenXlsxStyle-createOpenXslxStyle}{\code{TableOpenXlsxStyle$createOpenXslxStyle()}}
\item \href{#method-TableOpenXlsxStyle-asList}{\code{TableOpenXlsxStyle$asList()}}
\item \href{#method-TableOpenXlsxStyle-asJSON}{\code{TableOpenXlsxStyle$asJSON()}}
\item \href{#method-TableOpenXlsxStyle-asString}{\code{TableOpenXlsxStyle$asString()}}
\item \href{#method-TableOpenXlsxStyle-clone}{\code{TableOpenXlsxStyle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-new"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-new}{}}}
\subsection{Method \code{new()}}{
Create a new `TableOpenXlsxStyle` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$new(
  parentTable,
  baseStyleName = NULL,
  isBaseStyle = NULL,
  fontName = NULL,
  fontSize = NULL,
  bold = NULL,
  italic = NULL,
  underline = NULL,
  strikethrough = NULL,
  superscript = NULL,
  subscript = NULL,
  fillColor = NULL,
  textColor = NULL,
  hAlign = NULL,
  vAlign = NULL,
  wrapText = NULL,
  textRotation = NULL,
  indent = NULL,
  borderAll = NULL,
  borderLeft = NULL,
  borderRight = NULL,
  borderTop = NULL,
  borderBottom = NULL,
  valueFormat = NULL,
  minColumnWidth = NULL,
  minRowHeight = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{baseStyleName}}{The name of the base style in the table.}

\item{\code{isBaseStyle}}{`TRUE` when this style is the equivalent of a named style in
the table, `FALSE` if this style has additional settings over and above
the base style of the same name.}

\item{\code{fontName}}{The name of the font (single font name, not a CSS style
list).}

\item{\code{fontSize}}{The size of the font (units: point).}

\item{\code{bold}}{`TRUE` if text is bold.}

\item{\code{italic}}{`TRUE` if text is italic.}

\item{\code{underline}}{`TRUE` if text is underlined.}

\item{\code{strikethrough}}{`TRUE` if text has a line through it.}

\item{\code{superscript}}{`TRUE` if text is small and raised.}

\item{\code{subscript}}{`TRUE` if text is small and lowered.}

\item{\code{fillColor}}{The background colour for the cell (as a hex value, e.g.
#00FF00).}

\item{\code{textColor}}{The color of the text (as a hex value).}

\item{\code{hAlign}}{The horizontal alignment of the text:  left, center or right.}

\item{\code{vAlign}}{The vertical alignment of the text:  top, middle or bottom.}

\item{\code{wrapText}}{`TRUE` if the text is allowed to wrap onto multiple lines.}

\item{\code{textRotation}}{The rotation angle of the text or 255 for vertical.}

\item{\code{indent}}{The text indentation.}

\item{\code{borderAll}}{A list (with elements style and color) specifying the border
settings for all four sides of each cell at once.}

\item{\code{borderLeft}}{A list (with elements style and color) specifying the
border settings for the left border of each cell.}

\item{\code{borderRight}}{A list (with elements style and color) specifying the
border settings for the right border of each cell.}

\item{\code{borderTop}}{A list (with elements style and color) specifying the border
settings for the top border of each cell.}

\item{\code{borderBottom}}{A list (with elements style and color) specifying the
border settings for the bottom border of each cell.}

\item{\code{valueFormat}}{The Excel formatting applied to the field value.  One
of the following values: "GENERAL", "NUMBER", "CURRENCY", "ACCOUNTING",
"DATE", "LONGDATE", TIME, "PERCENTAGE", "FRACTION", "SCIENTIFIC",
"TEXT", "COMMA". Or for dates/datetimes, a combination of d, m, y. Or
for numeric values, use 0.00 etc.}

\item{\code{minColumnWidth}}{The minimum width of this column.}

\item{\code{minRowHeight}}{The minimum height of this row.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-isBasicStyleNameMatch"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-isBasicStyleNameMatch}{}}}
\subsection{Method \code{isBasicStyleNameMatch()}}{
Check if this style matches the specified base style name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$isBasicStyleNameMatch(baseStyleName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if the style name matches, `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-isFullStyleDetailMatch"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-isFullStyleDetailMatch}{}}}
\subsection{Method \code{isFullStyleDetailMatch()}}{
Check if this style matches the specified style properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$isFullStyleDetailMatch(
  baseStyleName = NULL,
  isBaseStyle = NULL,
  fontName = NULL,
  fontSize = NULL,
  bold = NULL,
  italic = NULL,
  underline = NULL,
  strikethrough = NULL,
  superscript = NULL,
  subscript = NULL,
  fillColor = NULL,
  textColor = NULL,
  hAlign = NULL,
  vAlign = NULL,
  wrapText = NULL,
  textRotation = NULL,
  indent = NULL,
  borderAll = NULL,
  borderLeft = NULL,
  borderRight = NULL,
  borderTop = NULL,
  borderBottom = NULL,
  valueFormat = NULL,
  minColumnWidth = NULL,
  minRowHeight = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to compare to.}

\item{\code{isBaseStyle}}{Whether the style being compared to is a base style.}

\item{\code{fontName}}{The font name to compare to.}

\item{\code{fontSize}}{The font size to compare to.}

\item{\code{bold}}{The style property bold to compare to.}

\item{\code{italic}}{The style property italic to compare to.}

\item{\code{underline}}{The style property underline to compare to.}

\item{\code{strikethrough}}{The style property strikethrough to compare to.}

\item{\code{superscript}}{The style property superscript to compare to.}

\item{\code{subscript}}{The style property subscript to compare to.}

\item{\code{fillColor}}{The style property fillColor to compare to.}

\item{\code{textColor}}{The style property textColor to compare to.}

\item{\code{hAlign}}{The style property hAlign to compare to.}

\item{\code{vAlign}}{The style property vAlign to compare to.}

\item{\code{wrapText}}{The style property wrapText to compare to.}

\item{\code{textRotation}}{The style property textRotation to compare to.}

\item{\code{indent}}{The style property indent to compare to.}

\item{\code{borderAll}}{The style property borderAll to compare to.}

\item{\code{borderLeft}}{The style property borderLeft to compare to.}

\item{\code{borderRight}}{The style property borderRight to compare to.}

\item{\code{borderTop}}{The style property borderTop to compare to.}

\item{\code{borderBottom}}{The style property borderBottom to compare to.}

\item{\code{valueFormat}}{The style value format to compare to.}

\item{\code{minColumnWidth}}{The style property minColumnWidth to compare to.}

\item{\code{minRowHeight}}{The style property minRowHeight to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if the style matches, `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-createOpenXslxStyle"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-createOpenXslxStyle}{}}}
\subsection{Method \code{createOpenXslxStyle()}}{
Create the `openxlsx` style based on the specified style properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$createOpenXslxStyle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-asList"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-asString"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-asString}{}}}
\subsection{Method \code{asString()}}{
Return the contents of this object as a string for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$asString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
