% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLikelihood.R
\name{getLikelihood}
\alias{getLikelihood}
\title{Get likelihood}
\usage{
getLikelihood(mcmc_output, choice = "complete_likelihood")
}
\arguments{
\item{mcmc_output}{The output from the mixture model.}

\item{choice}{The model fit score to use. Must be one of
``'observed_likelihood'``, ``'complete_likelihood'`` or ``'BIC'``. Defaults
to ``'complete_likelihood'``.}
}
\value{
A data.frame containing the model fit score of choice and the
iteration.
}
\description{
Extracts the model fit score from the mixture model output.
}
\examples{

# Data in a matrix format
X <- matrix(c(rnorm(100, 0, 1), rnorm(100, 3, 1)), ncol = 2, byrow = TRUE)

# Batch
batch_vec <- sample(seq(1, 5), replace = TRUE, size = 100)

# Sampling parameters
R <- 100
thin <- 5

# MCMC samples and BIC vector
samples <- runBatchMix(X, R, thin, batch_vec, "MVN")

lkl_df <- getLikelihood(samples)

}
