% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovbias_par.R
\name{ovbias_par}
\alias{ovbias_par}
\title{Compute bias adjusted treatment effect taking data frame as input.}
\usage{
ovbias_par(
  data,
  outcome,
  treatment,
  control,
  other_regressors = NULL,
  deltalow,
  deltahigh,
  Rhigh,
  e
)
}
\arguments{
\item{data}{Data frame.}

\item{outcome}{Outcome variable.}

\item{treatment}{Treatment variable.}

\item{control}{Control variables to add in the intermediate regression.}

\item{other_regressors}{Subset of control variables to add in the short regression (default is NULL).}

\item{deltalow}{The lower limit of delta.}

\item{deltahigh}{The upper limit of delta.}

\item{Rhigh}{The upper limit of Rmax.}

\item{e}{The step size.}
}
\value{
List with three elements:

\item{Data}{Data frame containing the bias and bias-adjusted treatment effect for each point on the grid}
\item{bias_Distribution}{Quantiles (2.5,5.0,50,95,97.5) of the empirical distribution of bias}
\item{bstar_Distribution}{Quantiles (2.5,5.0,50,95,97.5) of the empirical distribution of the bias-adjusted treatment effect}
}
\description{
Compute bias adjusted treatment effect taking data frame as input.
}
\examples{
## Load data set
data("NLSY_IQ")
 
## Set parameters for bounded box
Rhigh <- 0.61
deltalow <- 0.01
deltahigh <- 0.99
e <- 0.01

\dontrun{
## Compute bias and bias-adjusted treatment effect
OVB_par <- ovbias_par(data=NLSY_IQ,
outcome="iq_std",treatment="BF_months", 
control=c("age","sex","income","motherAge","motherEDU","mom_married","race"), 
other_regressors = c("sex","age"), deltalow=deltalow, 
deltahigh=deltahigh, Rhigh=Rhigh, e=e)

## Default quantiles of bias
OVB_par$bias_Distribution

# Default quantiles of bias-adjusted treatment effect
OVB_par$bstar_Distribution
}

}
