% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{get.mig.mcmc}
\alias{get.mig.mcmc}
\alias{has.mig.mcmc}
\title{Access MCMC results}
\usage{
get.mig.mcmc(
  sim.dir,
  chain.ids = NULL,
  low.memory = TRUE,
  burnin = 0,
  verbose = FALSE
)

has.mig.mcmc(sim.dir)
}
\arguments{
\item{sim.dir}{Directory where simulation results are stored.}

\item{chain.ids}{Chain identifiers in case only specific chains should be included
in the resulting object. By default, all available chains are included.}

\item{low.memory}{Logical. If \code{FALSE} full MCMC traces are loaded into memory.}

\item{burnin}{Burn-in used for loading traces. Only relevant, if \code{low.memory=FALSE}.}

\item{verbose}{Logical value. Switches log messages on and off.}
}
\value{
\code{get.mig.mcmc} returns an object of class \code{\link{bayesMig.mcmc.set}}.

\code{has.mig.mcmc} returns a logical value indicating if a migration simulation
    exists in the given directory.
}
\description{
Function \code{get.mig.mcmc} retrieves results of an MCMC simulation and creates an object of class
\code{\link{bayesMig.mcmc.set}}. Function \code{has.mig.mcmc} checks the existence of such results.
}
\examples{
\donttest{
# Toy simulation
sim.dir <- tempfile()
m <- run.mig.mcmc(nr.chains = 1, iter = 10, output.dir = sim.dir)

# can be later accessed via
m <- get.mig.mcmc(sim.dir)
summary(m)

has.mig.mcmc(sim.dir) # should be TRUE

unlink(sim.dir, recursive = TRUE)
}
}
\seealso{
\code{\link{run.mig.mcmc}}
}
