% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{get_prior}
\alias{get_prior}
\title{Get the prior distribution of a model parameter}
\usage{
get_prior(model,par,lag = 0)
}
\arguments{
\item{model}{a time series model class specified in \pkg{bayesforecast}.}

\item{par}{a string value with the desired parameter to impose a prior.
Possible arguments are: \code{"mu0"}, \code{"sigma0"}, \code{"ar"}, \code{"ma"}, \code{"arch"}, \code{"garch"},
\code{"mgarch"}, \code{"dfv"}, \code{"df"} or \code{"breg"}.}

\item{lag}{an optional integer value, indicates the desired parameter's lag to
impose a prior. If \code{lag = 0}, then the prior distribution will be applied
for all lags}
}
\value{
None. Prints the prior distribution of a desired parameter.
}
\description{
The functions gets the defined distribution of a defined model parameter
}
\examples{
# get all the ar parameters
dat = Sarima(birth,order = c(2,1,2))
get_prior(model = dat,par = "ar")

# change the mean constant parameter
dat = set_prior(model = dat,par = "mu0",dist = student(0,2.5,7))
get_prior(dat,par = "mu0")

# change and print only the second ma parameter
dat = set_prior(model = dat,par = "ma",dist = beta(2,2),lag = 2)
get_prior(dat,par = "ma")

}
\author{
Asael Alonzo Matamoros
}
