% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_code.R
\name{ou_nonlinear_tmg_stan_code}
\alias{ou_nonlinear_tmg_stan_code}
\title{Stan code for nonlinear OU model with SV and Student-t}
\usage{
ou_nonlinear_tmg_stan_code()
}
\value{
Character string containing Stan model code
}
\description{
Returns the complete Stan code for the nonlinear Ornstein-Uhlenbeck model
with cubic drift, stochastic volatility, and Student-t innovations.
Includes numerical guardrails and parallel computation support.
}
\details{
The model implements:
\itemize{
  \item Cubic drift: \eqn{\kappa(\theta - Y + a_3(Y-\theta)^3)}
  \item Stochastic volatility with AR(1) log-variance
  \item Student-t innovations with estimated degrees of freedom
  \item Hierarchical priors for sector-specific parameters
  \item Optional soft constraint on TMG variable
  \item Parallel likelihood computation via reduce_sum
}
}
\examples{
code <- ou_nonlinear_tmg_stan_code()
cat(substr(code, 1, 500))

}
