% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_epred.R
\name{posterior_epred}
\alias{posterior_epred}
\alias{posterior_epred.bayesnecfit}
\alias{posterior_epred.bayesmanecfit}
\title{Generates posterior linear predictions for objects fitted by
\code{\link{bnec}}}
\usage{
\method{posterior_epred}{bayesnecfit}(object, ...)

\method{posterior_epred}{bayesmanecfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Additional arguments to
\code{\link[brms]{posterior_epred}}.}
}
\value{
See \code{?brms:posterior_epred}.
}
\description{
Generates posterior linear predictions for objects fitted by
\code{\link{bnec}}. \code{object} should be of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.
}
\examples{
\dontrun{
library(bayesnec)
# Uses default `resolution` and `x_range` to generate `newdata` internally
posterior_epred(manec_example)
# Provide user-specified `newdata`
nd_ <- data.frame(x = seq(0, 3, length.out = 200))
ppreds <- posterior_epred(manec_example, ecx_val = 50, newdata = nd_,
                            make_newdata = FALSE)
ncol(ppreds) == 200 # cols are x, rows are iterations
# Predictions for raw input data
nec4param <- pull_out(manec_example, model = "nec4param")
preds <- posterior_epred(nec4param, make_newdata = FALSE)
x <- pull_brmsfit(nec4param)$data$x
plot(sort(x), preds[1, order(x)], type = "l", col = alpha("black", 0.1),
     ylim = c(-6, 3))
for (i in seq_len(nrow(preds))[-1]) {
  lines(sort(x), preds[i, order(x)], type = "l", col = alpha("black", 0.1))
}
}
}
