% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbl_s3.R
\name{bbl}
\alias{bbl}
\title{Boltzmann Bayes Learning Inference}
\usage{
bbl(
  formula,
  data,
  weights,
  xlevels = NULL,
  verbose = 1,
  method = "pseudo",
  novarOk = FALSE,
  testNull = TRUE,
  prior.count = 1,
  ...
)
}
\arguments{
\item{formula}{Formula for modeling}

\item{data}{Data for fitting}

\item{weights}{Vector of weights for each instance in data. Restricted to 
non-negative integer frequencies, recoding the number of times 
each row of data must be repeated. If \code{NULL},
assumed to be all 1. Fractional weights are not supported. Can be
a named column in \code{data}}

\item{xlevels}{List of factor levels for predictors. If \code{NULL},
will be inferred from data with factor levels ordered alphanumerically.}

\item{verbose}{Output verbosity level. Will be send to down-stream function
calls with one level lower}

\item{method}{BB inference algorithm; pseudo-likelihood inference (\code{'pseudo'})
or mean field (\code{'mf'})}

\item{novarOk}{If \code{TRUE}, will proceed with predictors having only one
level}

\item{testNull}{Repeat the inference for the `pooled' sample; i.e., under the
null hypothesis of all rows in data belonging to a single group}

\item{prior.count}{Prior count for computing single predictor and pairwise
frequencies}

\item{...}{Other parameters to \code{\link{mlestimate}}.}
}
\value{
A list of class \code{bbl} with the following elements:
  \item{coefficients}{List of inferred coefficients with elements
  \code{h}, \code{J}, \code{h0}, and \code{J0}. The bias  
  parameter \code{h} is a list of length equal to no. of 
  response groups, each of which is a list of the same struture as 
  \code{xlevels}: length equal to no. of predictors, containing vectors of 
  length equal to each predictor factor levels:
  \eqn{h_i^{(y)}(x)} represented by \code{h[[y]][[i]][x]}.
  The interaction parameter \code{J} is a list of lists of dimension
  \eqn{m \times m}, where \eqn{m} is the number of predictors. Each
  element is a matrix of dimension \eqn{L_i \times L_j}, where \eqn{L_i}
  and \eqn{L_j} are numbers of factor levels in predictor \code{i} and
  \code{j}: \eqn{J_{ij}^{(y)}(x_1,x_2)} represented by 
  \code{J[[y]][[i]][[j]][x1,x2]}. All elements of lists are named.
  The pooled parameters \code{h0} and \code{J0}, if computed,
  are of one less dimension, omitting response group argument.}
  \item{xlevels}{List of vectors containing predictor levels.}
  \item{terms}{The \code{terms} of \code{formula} input.}
  \item{groups}{Vector of response groups.}
  \item{groupname}{Name of the response variable.}
  \item{qJ}{Matrix of logicals whose elements record whether
    \code{formula} includes interaction between the two predictors.}
  \item{model}{Model data frame derived from \code{formula} and \code{data}.}
  \item{lkh}{Log likelihood.}
  \item{lz}{Vector log partition function. Used in \code{\link{predict}}.}
  \item{weights}{Vector of integral weights (frequencies).}
  \item{call}{Function call.}
  \item{df}{Degrees of freedom.}
}
\description{
Main driver for bbl inference
}
\details{
Formula argument and data are used to tabulate xlevels unless explicitly
given as list. Data are expected to be factors or integers. This function
is a driver interepreting formula and calls \code{bbi.fit}. Will stop with
error if any predictor has only one level unless \code{novarOk='TRUE'}.
Use \code{\link{removeConst}} to remove the non-varying predictors before 
calling if this happens.
}
\examples{
titanic <- as.data.frame(Titanic)
b <- bbl(Survived ~ (Class + Sex + Age)^2, data = titanic, weights = Freq)
b
}
\references{
\doi{10.18637/jss.v101.i05}
}
\author{
Jun Woo, \email{junwoo035@gmail.com}
}
