% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_distr.R
\name{create_beast2_input_distr_lh}
\alias{create_beast2_input_distr_lh}
\title{Creates the XML text for the \code{distribution} tag
with the \code{likelihood} ID,
of a BEAST2 parameter file.}
\usage{
create_beast2_input_distr_lh(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Creates the XML text for the \code{distribution} tag
with the \code{likelihood} ID,
of a BEAST2 parameter file,
in an unindented form
}
\details{
The \code{distribution} tag (with ID equals \code{likelihood})
has these elements:

\preformatted{
  <distribution id="likelihood"[...]>
     <distribution id="treeLikelihood"[...]>
       [...]
     </distribution>
  </distribution>
}

The \code{distribution} section with ID \code{treeLikelihood}
is created by \link{create_tree_likelihood_distr_xml}.

Zooming out:

\preformatted{
  <beast[...]>
    <run[...]>
      <distribution id="posterior"[...]>
        <distribution id="likelihood"[...]>
          [this section]
        </distribution>
      </distribution>
    </run>
  </beast>
}
}
\note{
this function is not intended for regular use, thus its
  long name length is accepted
}
\seealso{
this function is called by \code{create_beast2_input_distr},
  together with \code{create_beast2_input_distr_prior}
}
\author{
Richèl J.C. Bilderbeek
}
