% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{GetDescriptives}
\alias{GetDescriptives}
\title{Get Purchase Task Descriptive Summary}
\usage{
GetDescriptives(
  dat,
  bwplot = FALSE,
  outdir = "../plots/",
  device = "png",
  filename = "bwplot"
)
}
\arguments{
\item{dat}{Dataframe (long form)}

\item{bwplot}{Boolean. If TRUE, a ggplot2 box and whisker plot is saved. Default is FALSE.}

\item{outdir}{Character. Directory where plot will be saved. Be sure to include trailing '/'. Default location is one level up in "../plots/".}

\item{device}{Character. Type of file. Default is "png". Can be "pdf".}

\item{filename}{Character. Specify filename. Defualt is "bwplot".}
}
\value{
Dataframe with descriptive statistics
}
\description{
Calculates descriptive statistics from purchase task data.
}
\details{
Provides the following descriptive statistics from purchase task data at each price: mean consumption, median consumption, standard deviation of consumption, proportion of 0 values, number of NAs, minimum consumption, and maximum consumption.
}
\examples{
GetDescriptives(apt)
}
\author{
Brent Kaplan <bkaplan.ku@gmail.com>
}
