% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerbf01.R
\name{powerbf01}
\alias{powerbf01}
\title{Power and sample size calculations for z-test Bayes factor}
\usage{
powerbf01(
  n = NULL,
  power = NULL,
  k = 1/10,
  sd = 1,
  null = 0,
  pm,
  psd,
  type = c("two.sample", "one.sample", "paired"),
  dpm = pm,
  dpsd = psd,
  nrange = c(1, 10^5)
)
}
\arguments{
\item{n}{Sample size (per group for two-sample tests). Has to be \code{NULL}
if \code{power} is specified. Defaults to \code{NULL}}

\item{power}{Target power. Has to be \code{NULL} if \code{n} is specified.
Defaults to \code{NULL}}

\item{k}{Bayes factor threshold. Defaults to \code{1/10}, Jeffreys' threshold
for 'strong evidence' against the null hypothesis}

\item{sd}{Standard deviation of one observation (for \code{type =
"two.sample"} or \code{type = "one.sample"}) or of one difference within
a pair of observations (\code{type = "paired"}). Is assumed to be known.
Defaults to \code{1}}

\item{null}{Mean difference under the point null hypothesis. Defaults to
\code{0}}

\item{pm}{Mean of the normal prior assigned to the mean difference under the
alternative in the analysis}

\item{psd}{Standard deviation of the normal prior assigned to the mean
difference under the alternative in the analysis. Set to \code{0} to
obtain a point prior at the prior mean}

\item{type}{The type of test. One of \code{"two.sample"},
\code{"one.sample"}, \code{"paired"}. Defaults to \code{"two.sample"}}

\item{dpm}{Mean of the normal design prior assigned to the mean difference.
Defaults to the same value as the analysis prior \code{pm}}

\item{dpsd}{Standard deviation of the normal design prior assigned to the
mean difference. Defaults to the same value as the analysis prior
\code{psd}}

\item{nrange}{Sample size search range over which numerical search is
performed (only taken into account when \code{n} is \code{NULL}).
Defaults to \code{c(1, 10^5)}}
}
\value{
Object of class \code{"power.bftest"}, a list of the arguments
    (including the computed one) augmented with \code{method} and \code{note}
    elements
}
\description{
Compute probability that z-test Bayes factor is smaller than a
    specified threshold (the power), or determine sample size to obtain a
    target power.
}
\details{
This function provides a similar interface as
    \code{stats::power.t.test}. It also assumes that the data are continuous
    and that the parameter of interest is either a mean or a (standardized)
    mean difference. For some users, the low-level functions \link{nbf01} (to
    directly compute the sample size for a fixed power) and \link{pbf01} (to
    directly compute the power for a fixed sample size) may also be useful
    because they can be used for other data and parameter types.
}
\note{
A warning message will be displayed in case that the specified target
    power is not achievable under the specified analysis and design priors.
}
\examples{
## determine power
powerbf01(n = 100, pm = 0, psd = 1, dpm = 0.5, dpsd = 0)

## determine sample size
powerbf01(power = 0.99, pm = 0, psd = 1, dpm = 0.5, dpsd = 0)

}
\seealso{
\link{plot.power.bftest}, \link{nbf01}, \link{pbf01}, \link{bf01}
}
\author{
Samuel Pawel
}
