% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plots.R
\name{pca_plot_contributions}
\alias{pca_plot_contributions}
\title{Plot variable contributions}
\usage{
pca_plot_contributions(
  contributions,
  component = 1L,
  top_n = 20L,
  draw = TRUE,
  ...
)
}
\arguments{
\item{contributions}{Contribution matrix where rows correspond to variables
and columns to components.}

\item{component}{Integer index of the component to visualise.}

\item{top_n}{Number of variables with the largest absolute contribution to
include in the bar plot.}

\item{draw}{Logical; set to \code{FALSE} to skip plotting.}

\item{...}{Additional arguments passed to \code{\link[=barplot]{barplot()}}.}
}
\value{
A data frame with the variables and their contributions is returned
invisibly. When \code{draw = TRUE}, a bar plot of the top variables is produced.
}
\description{
Highlights the variables that contribute most to a selected principal
component. The helper works with dense matrices returned by
\code{\link[=pca_variable_contributions]{pca_variable_contributions()}} as well as with \code{bigmemory::big.matrix}
objects via sampling.
}
