% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigPLSR-package.R
\docType{package}
\name{bigPLSR-package}
\alias{bigPLSR-package}
\alias{bigPLSR}
\title{bigPLSR-package}
\description{
Provides Partial least squares Regression for big data. It allows for missing data in the explanatory variables. Repeated k-fold cross-validation of such models using various criteria. Bootstrap confidence intervals constructions are also available.
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r", algorithm = "simpls")
head(pls_predict_response(fit, X, ncomp = 2))

}
\references{
Maumy, M., Bertrand, F. (2023). PLS models and their extension for big data.
Joint Statistical Meetings (JSM 2023), Toronto, ON, Canada.

Maumy, M., Bertrand, F. (2023). bigPLS: Fitting and cross-validating
PLS-based Cox models to censored big data. BioC2023 — The Bioconductor
Annual Conference, Dana-Farber Cancer Institute, Boston, MA, USA.
Poster. https://doi.org/10.7490/f1000research.1119546.1
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/bigPLSR/}
  \item \url{https://github.com/fbertran/bigPLSR}
  \item Report bugs at \url{https://github.com/fbertran/bigPLSR/issues}
}

}
\author{
\strong{Maintainer}: Frederic Bertrand \email{frederic.bertrand@lecnam.net} (\href{https://orcid.org/0000-0002-0837-8281}{ORCID})

Authors:
\itemize{
  \item Myriam Maumy \email{myriam.maumy@ehesp.fr} (\href{https://orcid.org/0000-0002-4615-1512}{ORCID})
}

}
