% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_information_criteria}
\alias{pls_information_criteria}
\title{Compute information criteria for component selection}
\usage{
pls_information_criteria(object, X, Y, max_comp = NULL)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{X}{Training design matrix.}

\item{Y}{Training response matrix or vector.}

\item{max_comp}{Maximum number of components to consider.}
}
\value{
A data frame with RSS, RMSE, AIC and BIC per component.
}
\description{
Compute information criteria for component selection
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
pls_information_criteria(fit, X, y)
}
