# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Calculation of iterative regression components
#' @description Calculation of iterative regression components
#' @param X design matrix
#' @param y dependent variable
#' @param W weights
#' @export
XWXMatrixW <- function(X, y, W) {
    .Call('_bigReg_XWXMatrixW', PACKAGE = 'bigReg', X, y, W)
}

#' @title Singular value decomposition of the aggregated list from XWXMatrix(W) functions
#' @description Singular value decomposition of the aggregated list from XWXMatrix(W) functions
#' @param out list containing requisite computed values
#' @param epsilon either machine epsilon or user depermined epsilon
#' @export
SVD <- function(out, epsilon) {
    .Call('_bigReg_SVD', PACKAGE = 'bigReg', out, epsilon)
}

#' @title Calculation of iterative regression components
#' @description Calculation of iterative regression components
#' @param X design matrix
#' @param y dependent variable
#' @export
XWXMatrix <- function(X, y) {
    .Call('_bigReg_XWXMatrix', PACKAGE = 'bigReg', X, y)
}

#' @title writes numeric vector to file
#' @description writes numeric vector to file
#' @param v numeric vector
#' @param filePath dependent variable
#' @export
writeNumericVector <- function(v, filePath) {
    .Call('_bigReg_writeNumericVector', PACKAGE = 'bigReg', v, filePath)
}

#' @title reads numeric vector to file
#' @description reads numeric vector to file
#' @param size the length of the numeric vector
#' @param filePath dependent variable
#' @export
readNumericVector <- function(size, filePath) {
    .Call('_bigReg_readNumericVector', PACKAGE = 'bigReg', size, filePath)
}

#' @title creates factor from numeric vector and character vector as levels
#' @description The \code{CreateFactor} function creates a factor from a numeric 
#' 				vector and a character vector for levels
#' @param x numeric vector containing the numeric indices of the levels
#' @param levels character vector levels
#' @export
CreateFactor <- function(x, levels) {
    .Call('_bigReg_CreateFactor', PACKAGE = 'bigReg', x, levels)
}

#' @title mySeq function to sequence integers
#' @description a function to create a sequence of integers
#' @param start integer from where sequence should start
#' @param end integer where sequence should end
#' @export
mySeq <- function(start, end) {
    .Call('_bigReg_mySeq', PACKAGE = 'bigReg', start, end)
}

#' @title finds whether x is in y
#' @description finds whether x is in y
#' @param x item to be sought
#' @param y vector to be matched against
#' @export
myIn <- function(x, y) {
    .Call('_bigReg_myIn', PACKAGE = 'bigReg', x, y)
}

#' @title converts numeric vector to integer
#' @description converts numeric vector to integer
#' @param x numeric vector
#' @export
asInteger <- function(x) {
    .Call('_bigReg_asInteger', PACKAGE = 'bigReg', x)
}

#' @title read data frame block from file
#' @description read data frame block from file
#' @param size number of elements in the block
#' @param filePath path to where the block is stored
#' @param df an empty list having the same number of elements as columns in the table
#' @param ncol number of columns in the dataframe block
#' @param factors list containing factors
#' @param factor_indices numeric vector containing the indicies that denote the factors
#' @export
read_df_block <- function(size, filePath, df, ncol, factors, factor_indices) {
    .Call('_bigReg_read_df_block', PACKAGE = 'bigReg', size, filePath, df, ncol, factors, factor_indices)
}

#' @title read multiple blocks of data frames from file
#' @description read multiple blocks of data frames from file
#' @param size number of elements in each block
#' @param filePaths path to where the blocks are stored
#' @param df an empty list having the same number of elements as columns in the table
#' @param ncols number of columns in the dataframe block
#' @param factors list containing factors
#' @param factor_indices numeric vector containing the indicies that denote the factors
#' @export
read_df_blocks <- function(size, filePaths, df, ncols, factors, factor_indices) {
    .Call('_bigReg_read_df_blocks', PACKAGE = 'bigReg', size, filePaths, df, ncols, factors, factor_indices)
}

#' @title writes numeric vector to file
#' @description writes numeric vector to file
#' @param v numeric vector to be written to file
#' @param filePath path to file where the numeric vector should be written
#' @export
write_numeric_vector <- function(v, filePath) {
    .Call('_bigReg_write_numeric_vector', PACKAGE = 'bigReg', v, filePath)
}

#' @title row binding for benchmarking ...
#' @description row binding for benchmarking
#' @param x first matrix to be bound together
#' @param y second matrix to be bound together
#' @export
r_bind <- function(x, y) {
    .Call('_bigReg_r_bind', PACKAGE = 'bigReg', x, y)
}

#' @title read matrix block from file
#' @description read matrix block from file
#' @param filePath path to file where matrix should be read from
#' @param size total number of elements to be read
#' @param ncol number of columns in the matrix
#' @export
read_matrix_block <- function(filePath, size, ncol) {
    .Call('_bigReg_read_matrix_block', PACKAGE = 'bigReg', filePath, size, ncol)
}

#' @title read matrix blocks from file
#' @description read matrix blocks from file
#' @param filePaths file paths from where the matrix blocks will be read
#' @param size numeric vector containing the number of elements in each block
#' @param ncols number of columns in the matrix
#' @export
read_matrix_blocks <- function(filePaths, size, ncols) {
    .Call('_bigReg_read_matrix_blocks', PACKAGE = 'bigReg', filePaths, size, ncols)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_bigReg_RcppExport_registerCCallable', PACKAGE = 'bigReg')
})
