% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_vec}
\alias{split_vec}
\alias{split_df}
\title{Split object in blocks}
\usage{
split_vec(x, block_len, nb_split = ceiling(length(x)/block_len))

split_df(df, block_len, nb_split = ceiling(nrow(df)/block_len))
}
\arguments{
\item{x}{Vector to be divided into groups.}

\item{block_len}{Maximum length (or number of rows) of each block.}

\item{nb_split}{Number of blocks. Default uses the other 2 parameters.}

\item{df}{Data frame to be divided into groups.}
}
\value{
A list with the splitted objects.
}
\description{
Split object in blocks
}
\examples{
split_vec(1:10, block_len = 3)
str(split_df(iris, nb_split = 3))

}
