% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics_plot}
\alias{diagnostics_plot}
\title{Creates a Diagnostic Plot}
\usage{
diagnostics_plot(mod, variable = 1, dates = NULL)
}
\arguments{
\item{mod}{VAR model estimated using \code{\link{sparseVAR}},
\code{\link{sparseVARMA}}, or \code{\link{sparseVARX}}}

\item{variable}{Variable to show. Either numeric (which column) or character
(variable name)}

\item{dates}{Optional Date vector.}
}
\value{
Returns a ggplot2 plot
}
\description{
Creates a Diagnostic Plot
}
\examples{
# VAR example
dat <- simVAR(periods=200, k=2, p=5, decay = 0.1, seed = 6150533,
                       sparsity_pattern = "hvar")
mod <- sparseVAR(Y=scale(dat$Y), selection = "bic", h = 1)
diagnostics_plot(mod, variable = 1) # Plotting the first variable
\dontrun{
# VARMA example
data(varma.example)
varma <- sparseVARMA(Y=scale(Y.varma), VARMAselection="cv")
diagnostics_plot(varma, variable = 2) # Plotting the second variable
}
\dontrun{
# VARX example
data(varx.example)
varx <- sparseVARX(Y=scale(Y.varx), X=scale(X.varx), selection="cv")
diagnostics_plot(varx, variable = 1) # Plotting the first variable
}
}
