% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotvfray.R
\name{plotvfray}
\alias{plotvfray}
\title{Plots binocular visual field rays}
\usage{
plotvfray(leftvf, rghtvf, lefttheta, righttheta, fixdist, distplane)
}
\arguments{
\item{leftvf}{An 8 by 10 matrix of sensitivity threshold data for the left visual field}

\item{rghtvf}{An 8 by 10 matrix of sensitivity threshold data for the right visual field}

\item{lefttheta}{A number left eye rotating angle in radian}

\item{righttheta}{A number right eye rotating angle in radian}

\item{fixdist}{A 2 element vector the coordinates of the fixation point in cartesian system in mm.}

\item{distplane}{A number object distance in mm range from 0 to a maximum of 1500 mm.}
}
\value{
A plot of binocular visual field rays from a top view with left eye on the top.
}
\description{
\code{plotvfray} plots a figure showing how the left and right visual field sensitivity threshold data interact in the simulated binocular visual field.
}
\section{Warning}{

the unit of fixdist, pd and distplane must be in mm.
}

\examples{

rghtvf <- matrix(c(
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30, 30, 30, NA,
30, 30, 30, 30, 30, 30, 30,  0, 30, NA,
NA, 30, 30, 30, 30, 30, 30, 30, 30, NA,
NA, NA, 30, 30, 30, 30, 30, 30, NA, NA,
NA, NA, NA, 30, 30, 30, 30, NA, NA, NA
), ncol=10, byrow=TRUE)

leftvf <- rghtvf[, 10:1]

plotvfray(leftvf, rghtvf, -.05, .05, c(700, 0), 1000)

}
