% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanDir.R
\name{scanDir}
\alias{scanDir}
\title{Scan Directory for Image Analysis}
\usage{
scanDir(
  path,
  parallel = FALSE,
  backend = "PSOCK",
  cores = "auto",
  method = "edge",
  alpha = 1,
  sigma = 2,
  sizeFilter = FALSE,
  upperlimit = "auto",
  lowerlimit = "auto",
  proximityFilter = FALSE,
  radius = "auto",
  Rlog = FALSE
)
}
\arguments{
\item{path}{directory path to folder with images to be analyzed}

\item{parallel}{processing multiple images at the same time (default - FALSE)}

\item{backend}{'PSOCK' or 'FORK' (see \code{\link[parallel]{makeCluster}})}

\item{cores}{number of cores for parallel processing (numeric / 'auto') ('auto' uses 75\% of the available cores)}

\item{method}{choose method for object detection ('edge' / 'threshold')
(from \code{\link[biopixR]{objectDetection}})}

\item{alpha}{threshold adjustment factor (numeric / 'static' / 'interactive' / 'gaussian')
(from \code{\link[biopixR]{objectDetection}})}

\item{sigma}{smoothing (numeric / 'static' / 'interactive' / 'gaussian')
(from \code{\link[biopixR]{objectDetection}})}

\item{sizeFilter}{applying \code{\link[biopixR]{sizeFilter}} function (default - FALSE)}

\item{upperlimit}{highest accepted object size (only needed if sizeFilter = TRUE)}

\item{lowerlimit}{smallest accepted object size (numeric / 'auto')}

\item{proximityFilter}{applying \code{\link[biopixR]{proximityFilter}} function (default - FALSE)}

\item{radius}{distance from one center in which no other centers
are allowed (in pixels) (only needed if proximityFilter = TRUE)}

\item{Rlog}{creates a log markdown document, summarizing the results (default - FALSE)}
}
\value{
\code{data.frame} summarizing each analyzed image, including details such as the number of objects, average size and intensity, estimated rejections, and coverage.
}
\description{
This function scans a specified directory, imports images, and performs various analyses
including object detection, size filtering, and proximity filtering. Optionally, it can
perform these tasks in parallel and log the process.
}
\details{
The function scans a specified directory for image files, imports them,
and performs analysis using designated methods. The function is capable of
parallel processing, utilizing multiple cores to accelerate computation.
Additionally, it is able to log the results into an R Markdown file.
Duplicate images are identified through the use of MD5 sums. In addition a
variety of filtering options are available to refine the analysis. If
logging is enabled, the results can be saved and rendered into a report.
When \code{Rlog = TRUE}, an R Markdown file and a CSV file are generated in the
current directory. More detailed information on individual results,
can be accessed through saved RDS files.
}
\examples{
\donttest{
if (interactive()) {
  path2dir <- system.file("images", package = 'biopixR')
  results <- scanDir(path2dir, alpha = 'interactive', sigma = 'interactive')
  print(results)
  }
}
}
\seealso{
\code{\link[=imgPipe]{imgPipe()}}, \code{\link[=objectDetection]{objectDetection()}}, \code{\link[=sizeFilter]{sizeFilter()}}, \code{\link[=proximityFilter]{proximityFilter()}}, \code{\link[=resultAnalytics]{resultAnalytics()}}
}
