% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_resample.R
\name{create_resample}
\alias{create_resample}
\title{Create multiple resamples of a data set.}
\usage{
create_resample(data, reps = 100, summary = TRUE, seed = sample(0:9999, 1))
}
\arguments{
\item{data}{A data frame of count data,
with sites as rows and species as columns.}

\item{reps}{The number of resamples to create.}

\item{summary}{A logical indicating whether to calculate summary indices
using \code{\link{calc_diversity_indices}}.}

\item{seed}{A random seed to use for reproducibility.}
}
\value{
A list of data frames, if \code{summary = FALSE}, each data frame
is a resample of the original data set. If \code{summary = TRUE},
each data frame is a resample of the original data set with
diversity indices calculated using
\code{\link{calc_diversity_indices}}.
}
\description{
Create multiple resamples of a data set.
}
\examples{
rs <- create_resample(BCI, reps = 10, summary = TRUE)
}
