% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regmod.R
\name{regmod_regression}
\alias{regmod_regression}
\title{regmod_regression}
\usage{
regmod_regression(data, response)
}
\arguments{
\item{data}{A biosensor object.}

\item{response}{The name of the scalar response. The response must be a column name in data$variables.}
}
\value{
An object of class bregmod containing the components:
\code{beta} The beta coefficient functions of the fitting.
\code{prediction} The prediction for each training data.
\code{residuals} The residuals for each prediction value.
}
\description{
Performs the Wasserstein regression using quantile functions.
}
\examples{
# Data extracted from the paper: Hall, H., Perelman, D., Breschi, A., Limcaoco, P., Kellogg, R.,
# McLaughlin, T., Snyder, M., Glucotypes reveal new patterns of glucose dysregulation, PLoS
# biology 16(7), 2018.
file1 = system.file("extdata", "data_1.csv", package = "biosensors.usc")
file2 = system.file("extdata", "variables_1.csv", package = "biosensors.usc")
data = load_data(file1, file2)
regm = regmod_regression(data, "BMI")
}
