% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.R
\name{ridge_regression}
\alias{ridge_regression}
\title{ridge_regression}
\usage{
ridge_regression(data, response, w=NULL, method="manhattan", type="gaussian")
}
\arguments{
\item{data}{A biosensor object.}

\item{response}{The name of the scalar response. The response must be a column name in data$variables.}

\item{w}{A weight function.}

\item{method}{The distance measure to be used (@seealso parallelDist::parDist). By default manhattan distance.}

\item{type}{The kernel type ("gaussian" or "lapla"). By default gaussian distance.}
}
\value{
An object containing the components:
\code{best_alphas} Best coefficients obtained with leave-one-out cross-validation criteria.
\code{best_kernel} The kernel matrix of the best solution.
\code{best_sigma} The sigma parameter of the best solution.
\code{best_lambda} The lambda parameter of the best solution.
\code{sigmas} The sigma parameters used in the fitting according to the median heuristic fitting criteria.
\code{predictions} A matrix of predictions.
\code{r2} R-square of the different models fitted.
\code{error} Mean squared-error of the different models fitted.
\code{predictions_cross} A matrix of predictions obtained with leave-one-out cross-validation criteria.
}
\description{
Performs a Ridge regression.
}
\examples{
# Data extracted from the paper: Hall, H., Perelman, D., Breschi, A., Limcaoco, P., Kellogg, R.,
# McLaughlin, T., Snyder, M., Glucotypes reveal new patterns of glucose dysregulation, PLoS
# biology 16(7), 2018.
file1 = system.file("extdata", "data_1.csv", package = "biosensors.usc")
file2 = system.file("extdata", "variables_1.csv", package = "biosensors.usc")
data = load_data(file1, file2)
regm = ridge_regression(data, "BMI")
}
