% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouds.R
\name{alpha.bags}
\alias{alpha.bags}
\title{Create alpha bags}
\usage{
alpha.bags(bp, alpha = 0.95, which = NULL, col = ez.col[which], lty = 1,
lwd = 1, max = 2500, trace = TRUE, opacity = 0.25, outlying=FALSE)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{alpha}{numeric vector between 0 and 1 to determine coverage of the bag (\eqn{\alpha}), with default \code{0.95}.}

\item{which}{numeric vector indicating the selection of groups or classes to be fitted with \eqn{\alpha}-bags.}

\item{col}{vector of colours for the \eqn{\alpha}-bags. Multiple \eqn{\alpha} bags for one group will be displayed in the same colour.}

\item{lty}{vector of line types for the \eqn{\alpha}-bags. The same line type will be used per value of \eqn{\alpha}.}

\item{lwd}{vector of line widths for the \eqn{\alpha}-bags. The same line width will be used per value of \eqn{\alpha}.}

\item{max}{maximum number of samples to include in \eqn{\alpha}-bag calculations, with default 2500. If
more samples are in the group, a random sample of size max is taken for the computations.}

\item{trace}{logical, indicating progress of computation.}

\item{opacity}{level of opacity, with default \code{0.5}.}

\item{outlying}{logical indicating whether only outlying points should be plotted. Note the \code{which} argument may be overwritten when \code{TRUE}}
}
\value{
A list with the following components is available:
\item{alpha.bags}{list of coordinates for the \eqn{\alpha}-bags for each group.}
\item{col}{vector of colours for the \eqn{\alpha}-bags.}
\item{lty}{vector of line types for the \eqn{\alpha}-bags.}
\item{lwd}{vector of line widths for the \eqn{\alpha}-bags.}
}
\description{
This function produces \eqn{\alpha}-bags, which is a useful graphical summary of the
scatter plot. The alpha-bag refers to a contour which contains \eqn{\alpha}\% of the observations.
}
\examples{
biplot (iris[,1:4]) |> PCA(group.aes=iris[,5]) |> alpha.bags(alpha=0.95) |> plot()
biplot (iris[,1:4],group.aes=iris[,5]) |> PCA() |> alpha.bags(alpha=0.95) |> plot()

}
\references{
Gower, J., Gardner-Lubbe, S. & Le Roux, N. (2011, ISBN: 978-0-470-01255-0) \emph{Understanding Biplots.} Chichester, England: John Wiley & Sons Ltd.
}
