% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df_grid_var_autoplot.R
\name{grid_var_autoplot}
\alias{grid_var_autoplot}
\title{Create a complete variability plot for spatial interaction models in a data
frame}
\usage{
grid_var_autoplot(
  sim_df,
  key,
  flows = c("full", "destination", "attractiveness"),
  with_names = FALSE,
  with_positions = FALSE,
  cut_off = 100 * .Machine$double.eps^0.5,
  adjust_limits = FALSE,
  with_labels = FALSE,
  qmin = 0.05,
  qmax = 0.95,
  normalisation = c("origin", "full", "none"),
  fw_params = NULL,
  ...
)
}
\arguments{
\item{sim_df}{a data frame of spatial interaction models, an object of class
\code{sim_df}}

\item{key}{the wrapping variable which acts as group identifier for spatial
interaction models}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{with_names}{specifies whether the graphical representation includes
location names (\code{FALSE} by default)}

\item{with_positions}{specifies whether the graphical representation is based
on location positions (\code{FALSE} by default)}

\item{cut_off}{cut off limit for inclusion of a graphical primitive when
\code{with_positions = TRUE}. In the attractiveness or destination
representation, circles are removed when the corresponding upper quantile
value is below the cut off.}

\item{adjust_limits}{if \code{FALSE} (default value), the limits of the position
based graph are not adjusted after removing graphical primitives. This
eases comparison between graphical representations with different cut off
value. If \code{TRUE}, limits are adjusted to the data using the standard
ggplot2 behaviour.}

\item{with_labels}{if \code{FALSE} (default value) names are displayed using plain
texts. If \code{TRUE}, names are shown using labels.}

\item{qmin}{lower quantile, see details (default: 0.05)}

\item{qmax}{upper quantile, see details (default: 0.95)}

\item{normalisation}{when \code{flows="full"}, the flows can be reported without
normalisation (\code{normalisation="none"}, the default value) or they can be
normalised, either to sum to one for each origin location
(\code{normalisation="origin"}) or to sum to one globally
(\code{normalisation="full"}).}

\item{fw_params}{parameters for the \link[ggplot2:facet_wrap]{ggplot2::facet_wrap} call (if non
\code{NULL})}

\item{...}{additional parameters passed to \code{\link[=autoplot.sim_list]{autoplot.sim_list()}}}
}
\value{
a ggplot object
}
\description{
This function combines spatial variability interaction model representations
similar to the ones produced by \code{\link[=autoplot.sim_list]{autoplot.sim_list()}} into a single ggplot.
It provides an alternative graphical representation to the one produced by
\code{\link[=autoplot.sim_df]{autoplot.sim_df()}} and by \code{\link[=grid_autoplot]{grid_autoplot()}} for collection of spatial
interaction models in a \code{sim_df} object.
}
\details{
The rationale of \code{\link[=autoplot.sim_df]{autoplot.sim_df()}} is to display a single value for each
spatial interaction model (SIM) in the \code{sim_df} data frame. On the contrary,
this function produces a graphical representation of the variability of a
partition of the SIMs in the data frame, using \code{\link[=autoplot.sim_list]{autoplot.sim_list()}} as the
graphical engine.

The \code{key} parameter is used to partition the collection of SIMs. It can be
any expression which can be evaluated in the context of the \code{sim_df}
parameter. The function uses this parameter as the wrapping variable in a
call to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. It also uses it as a way to specific a
partition of the SIMs: each panel of the final figure is essentially the
variability graph generated by \code{\link[=autoplot.sim_list]{autoplot.sim_list()}} for the subset of the
SIMs in \code{sim_df} that match the corresponding value of \code{key}.

Parameters of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} can be set using the \code{fw_params}
parameter (in a list).
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
positions <- as.matrix(french_cities[1:10, c("th_longitude", "th_latitude")])
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.1),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
  destination_data = list(
    names = french_cities$name[1:10],
    positions = positions
  ),
  origin_data = list(
    names = french_cities$name[1:10],
    positions = positions
  )
)
all_flows_df <- sim_df(all_flows)
## group models by iteration number
grid_var_autoplot(all_flows_df, iterations)
## or by convergence status (showing destination)
grid_var_autoplot(all_flows_df, converged,
  flow = "destination",
  with_names = TRUE
) + ggplot2::coord_flip()
## using positions
grid_var_autoplot(all_flows_df, iterations,
  flow = "destination",
  with_positions = TRUE
) +
  ggplot2::scale_size_continuous(range = c(0, 3)) +
  ggplot2::coord_sf(crs = "epsg:4326")
\dontshow{\}) # examplesIf}
}
