% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\name{measure_bin}
\alias{measure_bin}
\title{Measure Performance for Binary Classification Models}
\usage{
measure_bin(obs, pred, cut = 0.5)
}
\arguments{
\item{obs}{A numeric or integer vector of observed binary class labels (0 or 1).}

\item{pred}{A numeric vector of predicted probabilities for the positive class.}

\item{cut}{A numeric threshold (between 0 and 1) to classify predictions into binary labels.}
}
\value{
A list containing:
\describe{
\item{\code{conf_mat}}{A confusion matrix comparing observed and predicted class labels.}
\item{\code{accuracy}}{The proportion of correct predictions.}
\item{\code{ROC}}{ROC generated using \code{pROC::roc}}
\item{\code{AUC}}{Area under the ROC curve.}
}
}
\description{
Evaluates the performance of a binary classification model using a confusion matrix and accuracy.
}
\examples{
obs <- c(1, 0, 1, 1, 0)
pred <- c(0.9, 0.4, 0.8, 0.7, 0.3)
cut <- 0.5
measure_bin(obs, pred, cut)
# Returns: list(conf_mat = <confusion matrix>, accuracy = 1, ROC = <ROC>, AUC = 1)

}
