% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coanc_tree.R
\name{coanc_tree}
\alias{coanc_tree}
\title{Calculate coancestry matrix corresponding to a tree}
\usage{
coanc_tree(tree)
}
\arguments{
\item{tree}{The coancestry tree relating the \code{k_subpops} subpopulations.
Must be a \code{phylo} object from the \code{ape} package (see \code{\link[ape:read.tree]{ape::read.tree()}}).
This tree may have a valid root edge (non-NULL \code{tree$root.edge} between 0 and 1), which is incorporated in the output calculations.}
}
\value{
The \code{k_subpops}-by-\code{k_subpops} coancestry matrix.
The order of subpopulations along the rows and columns of this matrix matches \code{tree$tip.label}.
The tip labels of the tree are copied to the row and column names of this matrix.
}
\description{
This function calculates the coancestry matrix of the subpopulations which are tip nodes in the input tree.
The edges of this tree are coancestry values relative to the parent node of each child node.
}
\details{
The calculation takes into account that total coancestries are non-linear functions of the per-edge coancestries.
Interestingly, the calculation can be simplified by a simple transformation performed by \code{\link[=tree_additive]{tree_additive()}}, see that for more information.
The self-coancestry (diagonal values) are the total coancestries of the tip nodes.
The coancestry between different subpopulations is the total coancestry of their last common ancestor node.
}
\examples{
# for simulating a tree with `rtree`
library(ape)

# a typical, non-trivial example
# number of tip subpopulations
k_subpops <- 3
# simulate a random tree
tree_subpops <- rtree( k_subpops )
# coancestry matrix of subpopulations
coancestry <- coanc_tree( tree_subpops )

}
\seealso{
\code{\link[=fit_tree]{fit_tree()}} for the inverse function (when applied to coancestry matrices generated by a tree without noise).

\code{\link[=tree_additive]{tree_additive()}} for calculating the additive edges.
This function is called internally by \code{coanc_tree} but the additive edges are not returned here, so call \code{\link[=tree_additive]{tree_additive()}} if you desired them.
}
