% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppw.R
\name{b.star}
\alias{b.star}
\title{Bootstrap Block Length Choice in the Stationary Case}
\usage{
b.star(data, mmax = NULL, Bmax = NULL, round = FALSE)
}
\arguments{
\item{data}{A time series or a matrix of time series data.}

\item{mmax}{An integer constant representing the maximum lag. By default
determined by the data.}

\item{Bmax}{An integer constant representing the maximum block length
By default determined by the data.}

\item{round}{A boolean indicating whether the resulting block lengths should be rounded.}
}
\value{
A 2 x k matrix, where each column represents a time series and each row
provides the optimal block length for the Moving Block Bootstrap or
Circular Block Bootstrap (first row) and the Nonoverlapping Block Bootstrap or
Stationary Bootstrap (second row).
}
\description{
This function calculates the optimal bootstrap block lengths for both the
Stationary Bootstrap, Nonoverlapping Block Bootstrap, Circular Block Bootstrap
and Moving Block Bootstrap methods, based on the data provided.
}
\details{
A \code{b.star} computes optimal block lengths for bootstrapping time series data,
utilizing autocorrelation and autocovariance measures. The function incorporates
several parameters, including  \code{mmax}, and \code{Bmax}, to refine the
block length calculations. The method involves a detailed analysis of the data's
autocorrelation structure to identify the most suitable block lengths for
bootstrapping procedures.
}
\examples{
# Simulate an ARIMA process
X <- arima.sim(n = 200, model = list(ar = c(0.5, 0.4), na = 0.5))
# Calculate the optimal bootstrap block lengths
optimal_choice <- b.star(X)
print(optimal_choice)
}
\references{
Politis, D.N., and White, H. (2004). Automatic block-length selection for the dependent bootstrap.
\emph{Econometric Reviews}, \bold{23}, 53-70.

Patton, A., Politis, D.N., and White, H. (2009). Correction to `Automatic
Block-Length Selection for the Dependent Bootstrap' by D.N. Politis and H. White."
\emph{Econometric Reviews},  \bold{28},  372-375.
}
\seealso{
\code{\link{blockboot}}, \code{\link{lam}}.
}
\author{
Original code in Matlab by A. Patton.
R translation and modifications by C. Parmeter and J. Racine, \email{racinej@mcmaster.ca}.
We are grateful to Andrew Patton and Dimitris Politis for their assistance and feedback,
and for allowing us to include this function in this package.
}
\keyword{blocks}
