\name{embb}
\alias{embb}
\alias{seasonalMean.embb}
\alias{seasonalVar.embb}
\alias{seasonalACF.embb}
\alias{meanCoeff.embb}
\alias{acfCoeff.embb}

\title{Characteristics for Extension of Moving Block Bootstrap Class}

\description{
The class of functions designed for bootstrap samples obtained using the Extension of Moving Block Bootstrap (EMBB) method or its circular version (CEMBB). These functions calculate seasonal means, seasonal variances, and seasonal autocovariances when a periodic time series with period length \emph{d} is considered. For periodic and almost periodically correlated time series, the functions calculate the Fourier coefficients of the mean and autocovariance functions.
}

\usage{
\method{seasonalMean}{embb}(x, period, \dots)
\method{seasonalVar}{embb}(x, period, \dots)
\method{seasonalACF}{embb}(x, tau, period, \dots)
\method{meanCoeff}{embb}(x, period, freq, \dots)
\method{acfCoeff}{embb}(x, tau, period, freq, \dots)
}

\arguments{
  \item{x}{An object of class \code{embb}.}
  \item{period}{An integer; period length of the original data.}
  \item{tau}{An integer or vector of integers; single lag or vector of lags.}
  \item{freq}{A vector of real numbers; vector of frequencies.}
  \item{\dots}{Additional arguments.}
}

\details{
These methods apply to objects of class \code{embb} typically obtained using the \code{\link{embb.sample}} function.
}

\value{
\itemize{
  \item \code{seasonalMean} and \code{seasonalVar} return a vector of length \code{period}.
  \item \code{seasonalACF} returns either:
    \itemize{
      \item A vector of length \code{period} if a single lag \code{tau} is specified.
      \item A matrix with \code{length(tau)} rows and \code{period} columns if \code{tau} is a vector.
    }
  \item \code{meanCoeff} returns a vector of the same length as \code{freq}.
  \item \code{acfCoeff} returns either:
    \itemize{
      \item A vector of length \code{length(freq)} if a single lag \code{tau} is specified.
      \item A matrix with \code{length(tau)} rows and \code{length(freq)} columns if \code{tau} is a vector.
    }
}
}

\references{
Bertail, P., & Dudek, A. (2025). \emph{Bootstrap for Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted. \cr
Dudek, A. E. (2015). Circular block bootstrap for coefficients of autocovariance function of almost periodically correlated time series. \emph{Metrika}, \bold{78}, 313-335. \cr
Dudek, A. E. (2018). Block bootstrap for periodic characteristics of periodically correlated time series. \emph{Journal of Nonparametric Statistics}, \bold{30}, 87-124.
}

\seealso{
\code{\link{embb.sample}}, \code{\link{seasonalMean.default}}, \code{\link{seasonalVar.default}}, \code{\link{seasonalACF.default}}
}

\keyword{Block bootstrap}
\keyword{Periodic time series}
\keyword{Almost periodically correlated time series}

\examples{
# Generate a periodically correlated time series
set.seed(123)
n=200
b <- arima.sim(n = n, model = list(ar = c(0.5, 0.4), na = 0.5))
period <- 12
x <- 5 * cos(2 * pi / period * (1:n)) + 5 * b * cos(2 * pi / period * (1:n))
X_ts <- ts(x)
bootstrapped_X <- embb.sample(X_ts, length.block = 15, method = "movingblock")
acf_results <- acfCoeff(bootstrapped_X, tau = 0, freq = 0)
mean_seasonal <- seasonalMean(bootstrapped_X, period = period)
}
