% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qVar.R
\name{qVar}
\alias{qVar}
\title{Estimating Variance of a Quantile}
\usage{
qVar(
  x,
  alpha,
  bandwidth = NULL,
  kernel = c("gaussian", "epanecbandwidthikov", "rectangular")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{alpha}{A numeric value from the interval \eqn{[0,1]} or a vector of probabilities.}

\item{bandwidth}{A positive numeric value representing the kernel bandwidth smoothing parameter.
If \code{NULL}, bandwidth is estimated using unbiased cross-validation method.}

\item{kernel}{A character string specifying the smoothing kernel to use:
\code{"gaussian"}, \code{"epanechnikov"}, or \code{"rectangular"}.}
}
\value{
A numeric vector containing the quantile variances.
}
\description{
This function calculates the quantile variance using kernel density estimation.
}
\details{
If \code{qa} is the quantile of order \code{alpha}, the quantile
variance \eqn{v} is given by:
\deqn{v = \frac{\alpha(1 - \alpha)}{\hat{f}_{h}(qa)^2}}
where
\itemize{
\item \eqn{ \hat{f}_{h}(x) = \frac{1}{n \cdot h} \sum_{i=1}^{n} K\left(\frac{x - X_i}{h}\right)},
\item \eqn{h} is the bandwidth,
\item \eqn{n} is the sample size.
}
}
\examples{
# Example usage of qVar function
data <- rnorm(100)
qVar(data, 0.5)

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Maritz, J. S. and Jarrett, R. G. (1978). A note on estimating the variance of
the sample median. \emph{Journal of the American Statistical Association}, \bold{73}, 194-196.
}
\seealso{
\code{\link{boots}}, \code{\link{confint}}.
}
\keyword{Quantile}
\keyword{Variance}
