% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tft_boot.R
\name{tft_boot}
\alias{tft_boot}
\title{TFT Bootstrap.}
\usage{
tft_boot(
  X,
  n = length(X),
  func,
  h = length(X)^{
     -2/3
 },
  kernel = 1,
  B,
  option = "local"
)
}
\arguments{
\item{X}{A numeric vector representing a time series.}

\item{n}{An integer; by default is the length of time series \code{X} but allow for a
smaller sample size m to perform moon bootstrap.}

\item{func}{A function to be applied to each column of the TFT bootstrap samples.}

\item{h}{A numeric value specifying the bandwidth used to compute the kernel estimator
in case of local bootstrap.
By default it is equal to \eqn{n^{-2/3}}.}

\item{kernel}{An integer value indicating the kernel type. Use \code{0}
for the Daniell kernel or any other value for the Bartlett-Priestley (Epanechnikov) kernel
(by default).}

\item{B}{An integer indicating the number of bootstrap replications.}

\item{option}{A character string specifying the bootstrap method:
\code{"local"} for local bootstrap, \code{"wild"} for wild bootstrap,
and \code{"res"} for residual bootstrap.}
}
\value{
An object of class \code{"boodd"}.
}
\description{
This function implements the Time Frequency Toggle (TFT)-Bootstrap
introduced in Kirch and Politis (2011).
}
\details{
The function performs the Time Frequency Toggle (TFT)-Bootstrap.
Its basic idea is to bootstrap the Fourier coefficients of the observed
time series, and then back-transforming them to obtain a bootstrap sample in the
time domain (see Kirch and Politis (2011)).
Then it computes
the specified function, \code{func}, on each bootstrap replicate.
Depending on the \code{option}, different bootstrap
methods are used to construct bootstrap samples:
\itemize{
\item \code{"local"} - local bootstrap.
\item \code{"wild"}-  wild bootstrap.
\item \code{"res"} - residual bootstrap.
}
}
\examples{
n=2000
phi0=0.5
p0=length(phi0)
theta0=0
q0=length(theta0)
sim <- arima.sim(n , model=list(ar = phi0, ma = theta0))
# The function to be bootstrapped using tft_boot (both variance and acf of order 1)
vc<-function(X){return(c(var(X),acf(X,plot=FALSE)$acf[2]))}
coeff=vc(sim)
bb1=tft_boot(sim,n=n,func=vc,B=999,option="local")
bb2=tft_boot(sim,n=n,func=vc,B=999,option="res")
bb3=tft_boot(sim,n=n,func=vc,B=999,option="wild")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Kirch, C. and Politis, D. N. (2011). TFT-Bootstrap: Resampling time series in the frequency
domain to obtain replicates in the time domain. \emph{Annals of Statistics}, vol.
\bold{39}, pp. 1427-1470
}
\seealso{
\code{\link{boot_local}}, \code{\link{boot_res}},
\code{\link{boot_wild}}.
}
\author{
We are grateful to Claudia Kirch for providing the original code in \code{R}.
}
\keyword{"Fast}
\keyword{"Frequency}
\keyword{Bootstrap}
\keyword{Fourier}
\keyword{Transform"}
\keyword{and}
\keyword{domain"}
\keyword{time}
