% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findParameter.R
\name{findChi2df}
\alias{findChi2df}
\title{Find degrees of freedom}
\usage{
findChi2df(ncp, q, p)
}
\arguments{
\item{ncp}{non-centrality parameter, a non-negative number}

\item{q}{a quantile}

\item{p}{probability corresponding to the quantile \code{q}}
}
\value{
The degrees of freedom parameter of the non-central Chi-squared
  distribution with non-centrality parameter \code{ncp} and with
  cumulative probability \code{p} at the quantile \code{q}.
}
\description{
Find the degrees of freedom parameter of a non-central
  Chi-squared distribution given a quantile, its corresponding
  probability, and the non-centrality parameter.
}
\examples{
library(boodist)
nu <- findChi2df(ncp = 10, q = 3, p = 0.1)
pchisq(3, df = nu, ncp = 10) # should be 0.1
}
