% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca_var_contrib}
\alias{pca_var_contrib}
\title{Compute variable contributions}
\usage{
pca_var_contrib(var_cos2, eigs, weighted_col = rep(1, ncol(var_cos2)))
}
\arguments{
\item{var_cos2}{variable coordinates}

\item{eigs}{eigs computed by \code{pca_eigen} or \code{pca_weighted_eigen}}

\item{weighted_col}{column weights}
}
\value{
A dataframe of variable contributions.
}
\description{
Return variable contributions
}
\examples{
library(booklet)

eigs <- iris[, -5] |>
  pca_standardize_norm() |>
  pca_weighted_eigen()

eigs |>
  pca_var_coords() |>
  pca_var_cos2() |>
  pca_var_contrib(eigs) |>
  head()
}
