% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxer2.R
\name{boxer2}
\alias{boxer2}
\title{Create multiple bounding boxes in an image based on sets of selected points}
\usage{
boxer2(
  names,
  file_path_input,
  color = "red",
  resize_x = NA,
  resize_y = NA,
  classifier,
  batch = length(names),
  outbox = FALSE,
  file_path_output = NA,
  show_classifier = FALSE
)
}
\arguments{
\item{names}{A vector that contains the names of JPG, PNG, or BMP image files.}

\item{file_path_input}{The directory that contains the image files.}

\item{color}{The name of the color for selected points.Default is "red".}

\item{resize_x}{Number of pixels to resize the x-axis. Default is NA to keep
original size.}

\item{resize_y}{Number of pixels to resize the y-axis. Default is NA to keep
original size.}

\item{classifier}{A data frame with columns "ref" (int), "class" (chr),
and "color" (chr). The "ref" value must be unique. "class" will appear as
the label, and "color" will be used as the color of the bounding box.}

\item{batch}{Number of images before prompt to truncate stream. Default is
length(names).}

\item{outbox}{Logical to run outBox and output images. Default is F.}

\item{file_path_output}{The directory where to save annotated images if
outbox is T.}

\item{show_classifier}{Logical to include the classifier above the bounding
box if outbox is T. Default is F.}
}
\value{
A dataframe with the bounding box coordinates for each image, and a
 new image file with the bounding box annotation for each of the images
 processed. Note the y-coordinate extends downward, not upward.The name of
 each output image file will be the same as the corresponding input file
 prefixed with "out_".
}
\description{
\code{boxer2} allows the user to identify multiple areas in an image around
which to generate bounding boxes and/or the ability to set a classifier per
bounding box.
}
\details{
Input a dataframe that captures reference information regarding the
classifiers. This includes a numeric reference, class (or name), and color.
Then stream a series of images (JPEG, PNG, BMP) from a directory. As each
image appears, indicate between 2 and 26 points around which boxer2 will
calculate a bounding box. Follow the prompt to provide the numeric reference
for the classifier. The next prompt allows to add another bounding box to the
same image or to advance to the next image.

The name of the original file, bounding box coordinates, classifiers, box
colors, and optional image resize values are returned in a dataframe. Boxer2
also offers the option to call the outBox function that will output each
image with its bounding box(es). If outputting the images, the show_classifier
parameter controls whether or not to show the class as a label above the
bounding box.

When an image appears, use the left mouse button to select the series of
points, and the right mouse button to signal completion and to move to the
next image. At least two points must be selected to record a bounding box. If
more than 26 points are selected, only the first 26 will be used. To skip
creating a bounding box for the current image, select the right mouse button
without selecting any points. Messages noting the images skipped will appear
at the end.

The dataframe of bounding box coordinates will only be returned when all of
the images have been cycled through, unless you set the batch parameter.  The
batch parameter allows for the images to be processed in batches with the
option to terminate and generate the output file at the end of each batch. The
batch parameter can be set for the number of images to cycle through before
the user is prompted to truncate the stream. Selecting "y" at the prompt will
truncate the stream and return the bounding box coordinates for all of the
images up to that point. Selecting any other key will continue to stream
through the next batch of images.

If all of the images have the same classifier and only one bounding box is
required per image, consider using the boxer function instead.
}
\examples{
# A sample classifier dataframe
dog_df <- data.frame(read.csv(system.file("extdata","dog_df.csv",
package = "boundingbox")), stringsAsFactors = FALSE)

# Use 1 to classify the first dog and 2 to classify the second.
\dontrun{
boxer2_results <- boxer2(names = c("SW1.jpg"),
file_path_input = system.file("extdata", package = "boundingbox"),
resize_x = 224, resize_y = 224, classifier = dog_df, outbox = FALSE)
}

}
