% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bvarpanel.R
\name{specify_panel_data_matrices}
\alias{specify_panel_data_matrices}
\title{R6 Class Representing DataMatricesBVARPANEL}
\description{
The class DataMatricesBVARPANEL presents the data matrices of dependent 
variables, \eqn{\mathbf{Y}_c}, and regressors, \eqn{\mathbf{X}_c}, for the 
Bayesian Panel VAR model for all countries \eqn{c = 1, ..., C}.
}
\examples{
data(ilo_dynamic_panel)
YX = specify_panel_data_matrices$new(data = ilo_dynamic_panel, p = 4)
length(YX$Y); names(YX$Y)


## ------------------------------------------------
## Method `specify_panel_data_matrices$get_data_matrices`
## ------------------------------------------------

data(ilo_dynamic_panel)
YX = specify_panel_data_matrices$new(ilo_dynamic_panel)
YX$get_data_matrices()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Y}}{a list with \code{C} elements with \code{(T_c + p) x N} matrices 
of dependent variables, \eqn{\mathbf{Y}_c}, possibly with missing 
observations given by \code{NA}.}

\item{\code{missing}}{a list with \code{C} elements with \code{T_c x N} matrices
containing value \code{1} for missing observation and \code{0} otherwise.}

\item{\code{type}}{an \code{N} character vector with elements set to "rate" or "real"
determining the truncation of the predictive density to \code{[0, 100]} and
\code{(-Inf, Inf)} (no truncation) for each of the variables.}

\item{\code{exogenous}}{a list with \code{C} elements with \code{(T_c + p) x N} 
matrices of exogenous variables.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataMatricesBVARPANEL-new}{\code{specify_panel_data_matrices$new()}}
\item \href{#method-DataMatricesBVARPANEL-get_data_matrices}{\code{specify_panel_data_matrices$get_data_matrices()}}
\item \href{#method-DataMatricesBVARPANEL-clone}{\code{specify_panel_data_matrices$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBVARPANEL-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBVARPANEL-new}{}}}
\subsection{Method \code{new()}}{
Create new data matrices DataMatricesBVARPANEL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_panel_data_matrices$new(
  data,
  p = 1L,
  exogenous = NULL,
  type = rep("real", ncol(data[[1]]))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a list containing \code{(T_c+p)xN} matrices with country-specific
time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{exogenous}}{a list containing \code{(T_c+p)xd} matrices with 
country-specific of exogenous variables. This matrix should not include a 
constant term.}

\item{\code{type}}{an \code{N} character vector with elements set to "rate" or "real"
determining the truncation of the predictive density to \code{[0, 100]} and
\code{(-Inf, Inf)} (no truncation) for each of the variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New data matrices DataMatricesBVARPANEL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBVARPANEL-get_data_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBVARPANEL-get_data_matrices}{}}}
\subsection{Method \code{get_data_matrices()}}{
Returns the data matrices DataMatricesBVARPANEL as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_panel_data_matrices$get_data_matrices()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(ilo_dynamic_panel)
YX = specify_panel_data_matrices$new(ilo_dynamic_panel)
YX$get_data_matrices()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBVARPANEL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBVARPANEL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_panel_data_matrices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
