% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleRegion_plot.R
\name{multipleRegion_plot}
\alias{multipleRegion_plot}
\title{Multiple Regions Connection Plot}
\usage{
multipleRegion_plot(input, significance = 0.05, regionCodeProvided = FALSE,
  view = "coronal", color = "blue", screenShot = "None")
}
\arguments{
\item{input}{it can accept two types of argument:
(1) output generated by "permkCCA_multipleRegion(...)" (with p value).
(2) output generated by summary_kcca() or meanConnection() (without p value).}

\item{significance}{significance level of hypothesis testing.
If there is no p value in your data (i.e. only region name and
region index, then set significance as NA)}

\item{regionCodeProvided}{use TRUE if region code was provided in nii2RData()
funciton and FALSE if not.}

\item{view}{view of brain to see. One can choose coronal, axial, SL, or SR.}

\item{color}{color of dots and lines. User can specify multiple colors in this
argument and the function will use these colors periodically.}

\item{screenShot}{whether to save figure as png. If it is "None", then the
figure will not be saved; If it is a name, for example, "plot.png",
then it will be saved as "plot.png".}
}
\value{
1-4 view(s) (depends on the number of views user would like to see)
of brain graphic network. All significant regions are connected by colored lines.
}
\description{
This function can draw connection line(s) among multiple brain regions,
based on the result from funciton permkCCA_multipleRegion(...).
}
\details{
If you provide an input with multiple patients, the function will ask
you to specify which patients data you would like to use.
}
\examples{
\donttest{
#It will take more than 3 min to run
#write data into temp file
filePath <- tempdir()
#the nii.gz fMRI imaging file is created (toy example)
oro.nifti::writeNIfTI(brainKCCA::input_img, paste(filePath, "/",  "temp", sep=""))
#read fMRI data
testcase1 <- nii2RData(niiFile1 = "temp", resolution = "3mm", imgPath = filePath)
result1<-permkCCA_multipleRegion(imageDat = testcase1, region = c(1,5,10))
multipleRegion_plot(result1, view="axial")
}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
