// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_breath_test_1_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 62> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 12, column 2 to column 25)",
  " (in 'string', line 13, column 2 to column 21)",
  " (in 'string', line 14, column 2 to column 24)",
  " (in 'string', line 15, column 2 to column 25)",
  " (in 'string', line 16, column 2 to column 21)",
  " (in 'string', line 17, column 2 to column 24)",
  " (in 'string', line 18, column 2 to column 28)",
  " (in 'string', line 19, column 2 to column 24)",
  " (in 'string', line 20, column 2 to column 27)",
  " (in 'string', line 21, column 2 to column 23)",
  " (in 'string', line 24, column 2 to column 30)",
  " (in 'string', line 25, column 2 to column 30)",
  " (in 'string', line 26, column 2 to column 33)",
  " (in 'string', line 28, column 2 to column 32)",
  " (in 'string', line 29, column 2 to column 32)",
  " (in 'string', line 30, column 2 to column 41)",
  " (in 'string', line 34, column 2 to column 23)",
  " (in 'string', line 35, column 2 to column 23)",
  " (in 'string', line 36, column 2 to column 25)",
  " (in 'string', line 37, column 2 to column 23)",
  " (in 'string', line 38, column 2 to column 26)",
  " (in 'string', line 39, column 2 to column 29)",
  " (in 'string', line 40, column 2 to column 26)",
  " (in 'string', line 41, column 2 to column 26)",
  " (in 'string', line 42, column 2 to column 27)",
  " (in 'string', line 43, column 2 to column 22)",
  " (in 'string', line 45, column 11 to column 12)",
  " (in 'string', line 45, column 4 to column 19)",
  " (in 'string', line 47, column 6 to column 14)",
  " (in 'string', line 48, column 6 to column 14)",
  " (in 'string', line 49, column 6 to column 19)",
  " (in 'string', line 50, column 6 to column 14)",
  " (in 'string', line 51, column 6 to column 17)",
  " (in 'string', line 52, column 6 to column 27)",
  " (in 'string', line 53, column 6 to column 20)",
  " (in 'string', line 54, column 6 to column 18)",
  " (in 'string', line 55, column 6 to column 36)",
  " (in 'string', line 56, column 6 to column 24)",
  " (in 'string', line 57, column 6 to column 71)",
  " (in 'string', line 46, column 18 to line 58, column 5)",
  " (in 'string', line 46, column 4 to line 58, column 5)",
  " (in 'string', line 62, column 6 to column 32)",
  " (in 'string', line 60, column 6 to column 49)",
  " (in 'string', line 59, column 4 to line 62, column 32)",
  " (in 'string', line 44, column 2 to line 63, column 3)",
  " (in 'string', line 3, column 2 to column 17)",
  " (in 'string', line 4, column 2 to column 24)",
  " (in 'string', line 5, column 2 to column 28)",
  " (in 'string', line 6, column 2 to column 21)",
  " (in 'string', line 7, column 8 to column 9)",
  " (in 'string', line 7, column 2 to column 36)",
  " (in 'string', line 8, column 18 to column 19)",
  " (in 'string', line 8, column 2 to column 28)",
  " (in 'string', line 9, column 20 to column 21)",
  " (in 'string', line 9, column 2 to column 27)",
  " (in 'string', line 12, column 9 to column 17)",
  " (in 'string', line 15, column 9 to column 17)",
  " (in 'string', line 18, column 9 to column 17)",
  " (in 'string', line 24, column 18 to column 26)",
  " (in 'string', line 25, column 18 to column 26)",
  " (in 'string', line 26, column 18 to column 26)"};
#include <stan_meta_header.hpp>
class model_breath_test_1 final : public model_base_crtp<model_breath_test_1> {
private:
  int n;
  int n_record;
  int student_t_df;
  double dose;
  std::vector<int> pat_group_i;
  Eigen::Matrix<double,-1,1> minute_data__;
  Eigen::Matrix<double,-1,1> pdr_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> minute{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> pdr{nullptr, 0};
public:
  ~model_breath_test_1() {}
  model_breath_test_1(stan::io::var_context& context__, unsigned int
                      random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_breath_test_1_namespace::model_breath_test_1";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 46;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 46;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 46;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 47;
      context__.validate_dims("data initialization", "n_record", "int",
        std::vector<size_t>{});
      n_record = std::numeric_limits<int>::min();
      current_statement__ = 47;
      n_record = context__.vals_i("n_record")[(1 - 1)];
      current_statement__ = 47;
      stan::math::check_greater_or_equal(function__, "n_record", n_record, 0);
      current_statement__ = 48;
      context__.validate_dims("data initialization", "student_t_df", "int",
        std::vector<size_t>{});
      student_t_df = std::numeric_limits<int>::min();
      current_statement__ = 48;
      student_t_df = context__.vals_i("student_t_df")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "student_t_df",
        student_t_df, 1);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "dose", "double",
        std::vector<size_t>{});
      dose = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 49;
      dose = context__.vals_r("dose")[(1 - 1)];
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "dose", dose, 0);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("pat_group_i", "n", n);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "pat_group_i", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      pat_group_i = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 51;
      pat_group_i = context__.vals_i("pat_group_i");
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "pat_group_i",
        pat_group_i, 0);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("minute", "n", n);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "minute", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      minute_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                        std::numeric_limits<double>::quiet_NaN());
      new (&minute)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(minute_data__.data(), n);
      {
        std::vector<local_scalar_t__> minute_flat__;
        current_statement__ = 53;
        minute_flat__ = context__.vals_r("minute");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 53;
          stan::model::assign(minute, minute_flat__[(pos__ - 1)],
            "assigning variable minute", stan::model::index_uni(sym1__));
          current_statement__ = 53;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "minute", minute, 0);
      current_statement__ = 54;
      stan::math::validate_non_negative_index("pdr", "n", n);
      current_statement__ = 55;
      context__.validate_dims("data initialization", "pdr", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      pdr_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                     std::numeric_limits<double>::quiet_NaN());
      new (&pdr) Eigen::Map<Eigen::Matrix<double,-1,1>>(pdr_data__.data(), n);
      {
        std::vector<local_scalar_t__> pdr_flat__;
        current_statement__ = 55;
        pdr_flat__ = context__.vals_r("pdr");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 55;
          stan::model::assign(pdr, pdr_flat__[(pos__ - 1)],
            "assigning variable pdr", stan::model::index_uni(sym1__));
          current_statement__ = 55;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 55;
      stan::math::check_greater_or_equal(function__, "pdr", pdr, -30);
      current_statement__ = 56;
      stan::math::validate_non_negative_index("m_raw", "n_record", n_record);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("k_raw", "n_record", n_record);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("beta_raw", "n_record",
        n_record);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("m", "n_record", n_record);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("k", "n_record", n_record);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("beta", "n_record", n_record);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = n_record + 1 + 1 + n_record + 1 + 1 + n_record + 1 + 1 +
      1;
  }
  inline std::string model_name() const final {
    return "model_breath_test_1";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_breath_test_1_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> m_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 1;
      m_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      local_scalar_t__ mu_m = DUMMY_VAR__;
      current_statement__ = 2;
      mu_m = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      local_scalar_t__ sigma_m = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_m = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> k_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 4;
      k_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 5;
      mu_k = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 6;
      sigma_k = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 7;
      beta_raw = in__.template read<
                   Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 8;
      mu_beta = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_beta = in__.template read_constrain_lb<local_scalar_t__,
                     jacobian__>(0, lp__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 10;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> m =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> k =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 14;
      stan::model::assign(m,
        stan::math::add(mu_m, stan::math::multiply(sigma_m, m_raw)),
        "assigning variable m");
      current_statement__ = 15;
      stan::model::assign(k,
        stan::math::add(mu_k, stan::math::multiply(sigma_k, k_raw)),
        "assigning variable k");
      current_statement__ = 16;
      stan::model::assign(beta,
        stan::math::add(mu_beta, stan::math::multiply(sigma_beta, beta_raw)),
        "assigning variable beta");
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "beta", beta, 0);
      {
        current_statement__ = 17;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(m_raw, 0, 1));
        current_statement__ = 18;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(mu_m, 40, 30));
        current_statement__ = 19;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma_m, 0, 10));
        current_statement__ = 20;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(k_raw, 0, 1));
        current_statement__ = 21;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(mu_k, -5, 2));
        current_statement__ = 22;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(sigma_k, -7, 2));
        current_statement__ = 23;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(beta_raw, 0, 1));
        current_statement__ = 24;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(mu_beta, 2, 0.5));
        current_statement__ = 25;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma_beta, 0, 2));
        current_statement__ = 26;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma, 0, 5));
        {
          current_statement__ = 27;
          stan::math::validate_non_negative_index("pdr1", "n", n);
          Eigen::Matrix<local_scalar_t__,-1,1> pdr1 =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
          current_statement__ = 41;
          for (int i = 1; i <= n; ++i) {
            int rec = std::numeric_limits<int>::min();
            local_scalar_t__ mn = DUMMY_VAR__;
            local_scalar_t__ exp_ktn = DUMMY_VAR__;
            local_scalar_t__ kn = DUMMY_VAR__;
            local_scalar_t__ betan = DUMMY_VAR__;
            current_statement__ = 34;
            rec = stan::model::rvalue(pat_group_i, "pat_group_i",
                    stan::model::index_uni(i));
            current_statement__ = 35;
            mn = stan::model::rvalue(m, "m", stan::model::index_uni(rec));
            current_statement__ = 36;
            kn = stan::model::rvalue(k, "k", stan::model::index_uni(rec));
            current_statement__ = 37;
            exp_ktn = stan::math::exp((-kn *
                        stan::model::rvalue(minute, "minute",
                          stan::model::index_uni(i))));
            current_statement__ = 38;
            betan = stan::model::rvalue(beta, "beta",
                      stan::model::index_uni(rec));
            current_statement__ = 39;
            stan::model::assign(pdr1, (((((dose * mn) * kn) * betan) *
              exp_ktn) * stan::math::pow((1 - exp_ktn), (betan - 1))),
              "assigning variable pdr1", stan::model::index_uni(i));
          }
          current_statement__ = 44;
          if (stan::math::logical_lt(student_t_df, 10)) {
            current_statement__ = 43;
            lp_accum__.add(stan::math::student_t_lpdf<propto__>(pdr,
                             student_t_df, pdr1, sigma));
          } else {
            current_statement__ = 42;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(pdr, pdr1, sigma));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_breath_test_1_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> m_raw =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      m_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      double mu_m = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      mu_m = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      double sigma_m = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      sigma_m = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> k_raw =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      k_raw = in__.template read<
                Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      double mu_k = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 5;
      mu_k = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      double sigma_k = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 6;
      sigma_k = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> beta_raw =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 7;
      beta_raw = in__.template read<
                   Eigen::Matrix<local_scalar_t__,-1,1>>(n_record);
      double mu_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      mu_beta = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      double sigma_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 9;
      sigma_beta = in__.template read_constrain_lb<local_scalar_t__,
                     jacobian__>(0, lp__);
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 10;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> m =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> k =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(n_record,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(m_raw);
      out__.write(mu_m);
      out__.write(sigma_m);
      out__.write(k_raw);
      out__.write(mu_k);
      out__.write(sigma_k);
      out__.write(beta_raw);
      out__.write(mu_beta);
      out__.write(sigma_beta);
      out__.write(sigma);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 14;
      stan::model::assign(m,
        stan::math::add(mu_m, stan::math::multiply(sigma_m, m_raw)),
        "assigning variable m");
      current_statement__ = 15;
      stan::model::assign(k,
        stan::math::add(mu_k, stan::math::multiply(sigma_k, k_raw)),
        "assigning variable k");
      current_statement__ = 16;
      stan::model::assign(beta,
        stan::math::add(mu_beta, stan::math::multiply(sigma_beta, beta_raw)),
        "assigning variable beta");
      current_statement__ = 11;
      stan::math::check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 12;
      stan::math::check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "beta", beta, 0);
      if (emit_transformed_parameters__) {
        out__.write(m);
        out__.write(k);
        out__.write(beta);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> m_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(m_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_record),
        "assigning variable m_raw");
      out__.write(m_raw);
      local_scalar_t__ mu_m = DUMMY_VAR__;
      current_statement__ = 2;
      mu_m = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu_m);
      local_scalar_t__ sigma_m = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_m = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_m);
      Eigen::Matrix<local_scalar_t__,-1,1> k_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(k_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_record),
        "assigning variable k_raw");
      out__.write(k_raw);
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 5;
      mu_k = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu_k);
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 6;
      sigma_k = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_k);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      current_statement__ = 7;
      stan::model::assign(beta_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n_record),
        "assigning variable beta_raw");
      out__.write(beta_raw);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 8;
      mu_beta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, mu_beta);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_beta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_beta);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 10;
      sigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "m_raw", "double",
        std::vector<size_t>{static_cast<size_t>(n_record)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "mu_m", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma_m",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "k_raw", "double",
        std::vector<size_t>{static_cast<size_t>(n_record)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "mu_k", "double",
        std::vector<size_t>{});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "sigma_k",
        "double", std::vector<size_t>{});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "beta_raw",
        "double", std::vector<size_t>{static_cast<size_t>(n_record)});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "mu_beta",
        "double", std::vector<size_t>{});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "sigma_beta",
        "double", std::vector<size_t>{});
      current_statement__ = 10;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> m_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> m_raw_flat__;
        current_statement__ = 1;
        m_raw_flat__ = context__.vals_r("m_raw");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(m_raw, m_raw_flat__[(pos__ - 1)],
            "assigning variable m_raw", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(m_raw);
      local_scalar_t__ mu_m = DUMMY_VAR__;
      current_statement__ = 2;
      mu_m = context__.vals_r("mu_m")[(1 - 1)];
      out__.write_free_lb(0, mu_m);
      local_scalar_t__ sigma_m = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_m = context__.vals_r("sigma_m")[(1 - 1)];
      out__.write_free_lb(0, sigma_m);
      Eigen::Matrix<local_scalar_t__,-1,1> k_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> k_raw_flat__;
        current_statement__ = 4;
        k_raw_flat__ = context__.vals_r("k_raw");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(k_raw, k_raw_flat__[(pos__ - 1)],
            "assigning variable k_raw", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(k_raw);
      local_scalar_t__ mu_k = DUMMY_VAR__;
      current_statement__ = 5;
      mu_k = context__.vals_r("mu_k")[(1 - 1)];
      out__.write_free_lb(0, mu_k);
      local_scalar_t__ sigma_k = DUMMY_VAR__;
      current_statement__ = 6;
      sigma_k = context__.vals_r("sigma_k")[(1 - 1)];
      out__.write_free_lb(0, sigma_k);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_record, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 7;
        beta_raw_flat__ = context__.vals_r("beta_raw");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 7;
          stan::model::assign(beta_raw, beta_raw_flat__[(pos__ - 1)],
            "assigning variable beta_raw", stan::model::index_uni(sym1__));
          current_statement__ = 7;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta_raw);
      local_scalar_t__ mu_beta = DUMMY_VAR__;
      current_statement__ = 8;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      out__.write_free_lb(0, mu_beta);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 9;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      out__.write_free_lb(0, sigma_beta);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 10;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write_free_lb(0, sigma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"m_raw", "mu_m", "sigma_m", "k_raw",
                "mu_k", "sigma_k", "beta_raw", "mu_beta", "sigma_beta",
                "sigma"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"m", "k", "beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    n_record)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(n_record)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(n_record)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_record)},
             std::vector<size_t>{static_cast<size_t>(n_record)},
             std::vector<size_t>{static_cast<size_t>(n_record)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "m_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "sigma_m");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "k_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "m" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "k" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "m_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "sigma_m");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "k_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "m" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "k" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"m_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"m\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"m_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"m\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_record) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((((((n_record + 1) + 1) + n_record) + 1)
      + 1) + n_record) + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (((n_record
      + n_record) + n_record));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((((((n_record + 1) + 1) + n_record) + 1)
      + 1) + n_record) + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (((n_record
      + n_record) + n_record));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_breath_test_1_namespace::model_breath_test_1;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_breath_test_1_namespace::profiles__;
}
#endif
#endif
