% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_set_options.R
\name{set_options}
\alias{set_options}
\title{Set up Bayesian model priors and settings}
\usage{
set_options(
  type = c("Independent", "Conjugate", "Shrinkage", "Horseshoe"),
  NG = set_NG(),
  SNG = set_SNG(),
  HS = set_HS(),
  SAR = set_SAR(),
  SLX = set_SLX(),
  SEM = set_SEM(),
  SV = set_SV(),
  ...
)
}
\arguments{
\item{type}{Character scalar with the prior type for the nested linear model.}

\item{NG}{Settings for the Normal-Gamma prior (independent or conjugate). See \code{\link{set_NG}}.}

\item{SNG}{Settings for the Normal-Gamma shrinkage prior (Polson and Scott, 2010). See \code{\link{set_NG}}.}

\item{HS}{Settings for the Horseshoe shrinkage prior (Makalic and Schmidt, 2015). See \code{\link{set_NG}}.}

\item{SAR}{Settings for the spatial autoregressive setup. See \code{\link{set_SAR}}.}

\item{SLX}{Settings for the spatially lagged explanatory setup. See \code{\link{set_SAR}}. Note that settings for
the spatial term 'theta' are provided to \emph{NG} instead.}

\item{SEM}{Settings for the spatial error setup. See \code{\link{set_SAR}}.}

\item{SV}{Settings for the stochastic volatility setup. See \code{\link{set_SV}}.}

\item{...}{Used to provide custom prior elements.}
}
\value{
Returns a list with priors and settings for a Bayesian model.
}
\description{
Set up Bayesian model priors and settings
}
\examples{
set_options("Shrinkage", SNG = set_SNG(lambda_a = 1, lambda_b = 1))
}
