% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{extractlinks}
\alias{extractlinks}
\title{Extract the links from a bstrlstate object into a list of streaminglinks
objects.}
\usage{
extractlinks(state, unfinished = c("warn", "ignore", "fail"))
}
\arguments{
\item{state}{A bstrlstate object returned by one of the main RL functions.}

\item{unfinished}{What to do if passed an unfinished sampling state, e.g.
from multifileRL. See details.}
}
\value{
A list of streaminglinks objects, one per posterior sample contained
in 'state'.
}
\description{
Extract the links from a bstrlstate object into a list of streaminglinks
objects.
}
\details{
The function does one of three things when passed an unfinished
sampling state, e.g. from multifileRL after time limit expired. For
'ignore', the desired burn is performed and any remaining samples are
discarded, returning only the number of completed post-burn samples. If
the link state does not have any completed post-burn samples, an empty
list is returned. If 'warn' (default), the same action is performed as
'ignore' but a warning is issued. If 'fail', any unfinished link state will
cause the function to fail.
}
\examples{
data(geco_small_result)
posterior <- extractlinks(geco_small_result, unfinished="fail")
stopifnot(ncol(geco_small_result$Z) == length(posterior))
class(posterior)
class(posterior[[1]])

}
