% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_coveredCall.R
\name{coveredCall}
\alias{coveredCall}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for Covered Call and draws its graph in the Plots tab.}
\usage{
coveredCall(
  ST,
  X,
  C,
  S0,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Covered Call ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium received on shorted call.}

\item{S0}{Initial Stock Price}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Covered Call.
}
\description{
This strategy is also known as buy-write strategy that results from buying stock and writing a call option with a strike price X against the stock position. The outlook of trader or investor on the stock price is neutral to bullish. The covered call strategy has the same payoff as writing a put option (short/naked put). While maintaining the long stock position, the trader can generate income by periodically selling OTM call options (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and Breakeven (BE) point for Covered Call and draws its graph in the Plots tab.
}
\examples{
coveredCall(17,17,1.44,15.84)
coveredCall(50,50,4,48,hl=0.7,hu=1.2)
coveredCall(1000,1000,10,990,hl=0.97,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
