% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_barplot.R
\docType{methods}
\name{barplot}
\alias{barplot}
\alias{barplot,revenue-method}
\alias{barplot,expense-method}
\alias{barplot,operations-method}
\title{Plot business plan transactions}
\usage{
barplot(height, ...)

\S4method{barplot}{revenue}(height, resolution = "month", types = "default", ...)

\S4method{barplot}{expense}(height, resolution = "month", types = "default", ...)

\S4method{barplot}{operations}(height, resolution = "month", scope = "profit",
      types = "default", ...)
}
\arguments{
\item{height}{An object of class \code{\link[businessPlanR:operations-class]{operations}},
      \code{\link[businessPlanR:revenue-class]{revenue}} or \code{\link[businessPlanR:expense-class]{expense}}.}

\item{...}{Any other argument suitable for \code{barplot()}.}

\item{resolution}{One of \code{"month"}, \code{"quarter"}, or \code{"year"}.}

\item{types}{Character string naming the model types defined by
\code{\link[businessPlanR:set_types]{set_types}} to be used.}

\item{scope}{One of \code{"revenue"}, \code{"expense"}, \code{"rev_exp"},
      \code{"profit"}.}
}
\value{
See \code{\link[graphics:barplot]{barplot}}.
}
\description{
Plot business plan transactions
}
