% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doi_datacite.R
\name{DoiDatacite}
\alias{DoiDatacite}
\title{Wrangle DataCite metadata into Zotero-type format}
\usage{
DoiDatacite(data, meta = list(), silent = TRUE, log = list())
}
\arguments{
\item{data}{XML data from DataCite containing metadata}

\item{meta}{A list collecting all metadata used to create , Default: list()}

\item{silent}{c2z is noisy, tell it to be quiet, Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Query DataCite by DOI and fetch metadata
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # `DoiDatacite` is called from `ZoteroDoi` (if item found)
  example <- ZoteroDoi("10.17605/OSF.IO/7HZ4P")

  # Use `ZoteroIndex` to print
  # Print index using `ZoteroIndex`
  if (any(nrow(example$data))) {
    ZoteroIndex(example$data) |>
      dplyr::select(name) |>
      print(width = 80)

    # Display catalog
    example$data$libraryCatalog
  }
}
}
