% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_get.R
\name{ZoteroGet}
\alias{ZoteroGet}
\title{Get collections and items from a Zotero library}
\usage{
ZoteroGet(
  zotero,
  use.collection = TRUE,
  use.item = FALSE,
  append.collections = FALSE,
  append.items = FALSE,
  append.top = FALSE,
  append.file = FALSE,
  custom.url = NULL,
  open.query = NULL,
  limit = 100,
  start = 0,
  format = "json",
  item.keys = NULL,
  collection.keys = NULL,
  item.type = NULL,
  library.type = NULL,
  linkwrap = 1,
  style = "apa",
  locale = "en-US",
  all.results = TRUE,
  max.results = NULL,
  result.type = NULL,
  force = FALSE,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{use.collection}{Use collection key if present in Zotero list, Default:
TRUE}

\item{use.item}{Use item key if present in Zotero list, Default: FALSE}

\item{append.collections}{Append `/collections/` to Zotero API url, Default:
FALSE}

\item{append.items}{Append `/items/` to Zotero API url, Default: FALSE}

\item{append.top}{Append `/top/` to Zotero API url, Default: FALSE}

\item{append.file}{Append `/file/` to Zotero API url, Default: FALSE}

\item{custom.url}{Use a custom Zotero API url, Default: NULL}

\item{open.query}{Use your own query, Default: NULL}

\item{limit}{Number of results per query (max 100), Default: 100}

\item{start}{Starting position of query (0 = first result), Default: 0}

\item{format}{Format of response from the Zotero API, Default: 'json'}

\item{item.keys}{Specified vector of items keys, Default: NULL}

\item{collection.keys}{Specified vector of collection keys, Default: NULL}

\item{item.type}{Items to search for (NULL = everything), Default: NULL}

\item{library.type}{Commma-separated data from Zotero (i.e., data, bib,
citation), Default: NULL}

\item{linkwrap}{Set URL (e.g., DOI) as HTML link (1 = yes), Default: 1}

\item{style}{Citation style to use for appended bibliography and/or
citations, Default: apa}

\item{locale}{Desired language format of bibliography, Default: 'en-US'}

\item{all.results}{Find all results in query, Default: TRUE}

\item{max.results}{Do you need a limit?, Default: NULL}

\item{result.type}{Pointless linguistics to display result type (default =
`result`), Default: NULL}

\item{force}{Force is seldom wise, but sometimes..., Default: FALSE}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g.,
  collections and items)
}
\description{
Get
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Define Zotero list according to default setings
  zotero = Zotero(
    user = FALSE,
    id = "4827927",
    api = "RqlAmlH5l1KPghfCseAq1sQ1"
  )

  # Query default group Zotero library for 1 item
  example <- ZoteroGet(
    zotero,
    max.results = 1
  )

  # Print index using `ZoteroIndex`
  if (any(nrow(example$results))) {
  ZoteroIndex(example$results) |>
    dplyr::select(name) |>
    print(width = 80)
  }
}
}
\seealso{
\code{\link[httr]{RETRY}}
}
