% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subchart.R
\name{subchart}
\alias{subchart}
\alias{subchart.c3}
\title{Add Subchart}
\usage{
subchart(c3, height = 20, onbrush = NULL)

\method{subchart}{c3}(c3, height = 20, onbrush = NULL)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{height}{integer pixels}

\item{onbrush}{character js function, wrap character or character vector in JS()}
}
\value{
c3
}
\description{
Subcharts are defined in multiple axis by passing a single `data.frame`. Subcharts are listed as an
experimental feature in the \href{http://c3js.org/reference.html#subchart-onbrush}{C3 documentation}).
}
\examples{
data.frame(a = abs(rnorm(20) * 10),
           b = abs(rnorm(20) * 10),
           date = seq(as.Date("2014-01-01"), by = "month", length.out = 20)) \%>\%
     c3(x = 'date') \%>\%
     subchart(height = 20, onbrush = 'function (domain) { console.log(domain) }')

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{grid}}, \code{\link{legend}},
  \code{\link{region}}, \code{\link{tooltip}},
  \code{\link{xAxis}}, \code{\link{zoom}}
}
\concept{c3}
\concept{subchart}
