% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-auxiliar.R
\name{calibrar_demo}
\alias{calibrar_demo}
\title{Demos for the calibrar package}
\usage{
calibrar_demo(path = NULL, model = NULL, ...)
}
\arguments{
\item{path}{Path to create the demo files}

\item{model}{Model to be used in the demo files, see details.}

\item{\dots}{Additional parameters to be used in the construction of
the demo files.}
}
\value{
A list with the following elements:
\item{path}{Path were the files were saved}
\item{par}{Real value of the parameters used in the demo} 
\item{setup}{Path to the calibration setup file} 
\item{guess}{Values to be provided as initial guess to the calibrate function} 
\item{lower}{Values to be provided as lower bounds to the calibrate function} 
\item{upper}{Values to be provided as upper bounds to the calibrate function} 
\item{phase}{Values to be provided as phases to the calibrate function} 
\item{constants}{Constants used in the demo, any other variable not listed here.} 
\item{value}{NA, set for compatibility with summary methods.} 
\item{time}{NA, set for compatibility with summary methods.} 
\item{counts}{NA, set for compatibility with summary methods.}
}
\description{
Creates demo files able to be processed for a full calibration using
the calibrar package
}
\details{
Current implemented models are:
\describe{
\item{PoissonMixedModel}{Poisson Autoregressive Mixed model for the dynamics 
of a population in different sites:
\deqn{log(\mu_{i, t+1}) = log(\mu_{i, t}) + \alpha + \beta X_{i, t} + \gamma_t}
where \eqn{\mu_{i, t}} is the size of the population in site \eqn{i} at year \eqn{t}, 
\eqn{X_{i, t}} is the value of an environmental variable in site \eqn{i} at year \eqn{t}. 
The parameters to estimate were \eqn{\alpha}, \eqn{\beta}, and \eqn{\gamma_t}, the 
random effects for each year, \eqn{\gamma_t \sim N(0,\sigma^2)}, and the initial 
population at each site \eqn{\mu_{i, 0}}. We assumed that the observations 
\eqn{N_{i,t}} follow a Poisson distribution with mean \eqn{\mu_{i, t}}.}
\item{PredatorPrey}{Lotka Volterra Predator-Prey model. The model is defined 
by a system of ordinary differential equations for the abundance of prey $N$ and predator $P$:
\deqn{\frac{dN}{dt} = rN(1-N/K)-\alpha NP}
\deqn{\frac{dP}{dt} = -lP + \gamma\alpha NP}
The parameters to estimate are the prey’s growth rate \eqn{r}, the predator’s 
mortality rate \eqn{l}, the carrying capacity of the prey \eqn{K} and \eqn{\alpha} 
and \eqn{\gamma} for the predation interaction. Uses \code{deSolve} package 
for numerical solution of the ODE system.}
\item{SIR}{Susceptible-Infected-Recovered epidemiological model. 
The model is defined by a system of ordinary differential equations for the 
number of susceptible $S$, infected $I$ and recovered $R$ individuals:
\deqn{\frac{dS}{dt} = -\beta S I/N}
\deqn{\frac{dI}{dt} = \beta S I/N -\gamma I}
\deqn{\frac{dR}{dt} = \gamma I}
The parameters to estimate are the  average number of contacts per person per 
time \eqn{\beta} and the instant probability of an infectious individual 
recovering \eqn{\gamma}. Uses \code{deSolve} package for numerical solution of the ODE system.}
\item{IBMLotkaVolterra}{Stochastic Individual Based Model for Lotka-Volterra model. Uses \code{ibm} package for the simulation.}
}
}
\examples{
\dontrun{

summary(ahr)
set.seed(880820)
path = NULL # NULL to use the current directory
# create the demonstration files
demo = calibrar_demo(path=path, model="PredatorPrey", T=100) 
# get calibration information
calibration_settings = calibration_setup(file = demo$setup)
# get observed data
observed = calibration_data(setup = calibration_settings, path=demo$path)
# Defining 'run_model' function
run_model = calibrar:::.PredatorPreyModel
# real parameters
cat("Real parameters used to simulate data\n")
print(unlist(demo$par)) # parameters are in a list
# objective functions
obj  = calibration_objFn(model=run_model, setup=calibration_settings, observed=observed, T=demo$T)
obj2 = calibration_objFn(model=run_model, setup=calibration_settings, observed=observed, 
T=demo$T, aggregate=TRUE)
cat("Starting calibration...\n")
cat("Running optimization algorithms\n", "\t")
cat("Running optim AHR-ES\n")
ahr = calibrate(par=demo$guess, fn=obj, lower=demo$lower, upper=demo$upper, phases=demo$phase)
summary(ahr)
} 
}
\references{
Oliveros-Ramos and Shin (2014)
}
\author{
Ricardo Oliveros--Ramos
}
\keyword{calibration}
\keyword{demo}
