% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-auxiliar.R
\name{.read_configuration}
\alias{.read_configuration}
\title{Read a configuration file.}
\usage{
.read_configuration(
  file,
  recursive = TRUE,
  keep.names = TRUE,
  conf.key = NULL,
  ...
)
}
\arguments{
\item{file}{File to read the configuration}

\item{recursive}{Should 'conf.key' keys be read as additional configuration files? Default is TRUE.}

\item{keep.names}{Should names be kept as they are? By default, are converted to lower case.}

\item{conf.key}{String indicating the leading key to find an additional configuration file.}

\item{...}{Additional arguments, not currently in use.}
}
\description{
File is expected to have lines of the form 'key SEP value' where key is the
name of the parameter, SEP a separator (can be '=' ',', ';') and value the value
of the parameter itself. The SEP for each line is determined and parameters values are
returned as a list.
}
